/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.twitter.data.proto.Misc;
import com.twitter.elephantbird.pig.util.ProtobufTuple;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.NonSpillableDataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufToPig {
    private static final Logger LOG = LoggerFactory.getLogger(ProtobufToPig.class);
    private static final TupleFactory tupleFactory_ = TupleFactory.getInstance();
    private final CoercionLevel coercionLevel_;

    public ProtobufToPig() {
        this(CoercionLevel.kAllowCoercionToPigMaps);
    }

    public ProtobufToPig(CoercionLevel coercionLevel) {
        this.coercionLevel_ = coercionLevel;
    }

    public Tuple toTuple(Message msg) {
        if (msg == null) {
            return null;
        }
        Descriptors.Descriptor msgDescriptor = msg.getDescriptorForType();
        Tuple tuple = tupleFactory_.newTuple(msgDescriptor.getFields().size());
        int curField = 0;
        try {
            for (Descriptors.FieldDescriptor fieldDescriptor : msgDescriptor.getFields()) {
                Object fieldValue = msg.getField(fieldDescriptor);
                if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                    tuple.set(curField++, this.messageToTuple(fieldDescriptor, fieldValue));
                    continue;
                }
                tuple.set(curField++, this.singleFieldToTuple(fieldDescriptor, fieldValue));
            }
        }
        catch (ExecException e) {
            LOG.warn("Could not convert msg " + msg + " to tuple", (Throwable)e);
        }
        return tuple;
    }

    public Object fieldToPig(Descriptors.FieldDescriptor fieldDescriptor, Object fieldValue) {
        if (fieldValue == null) {
            return null;
        }
        if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
            return this.messageToTuple(fieldDescriptor, fieldValue);
        }
        return this.singleFieldToTuple(fieldDescriptor, fieldValue);
    }

    protected Object messageToTuple(Descriptors.FieldDescriptor fieldDescriptor, Object fieldValue) {
        if (fieldValue == null) {
            return null;
        }
        assert (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) : "messageToTuple called with field of type " + fieldDescriptor.getType();
        if (fieldDescriptor.isRepeated()) {
            List messageList = (List)(fieldValue != null ? fieldValue : Lists.newArrayList());
            if (this.coercionLevel_ == CoercionLevel.kAllowCoercionToPigMaps && fieldDescriptor.getMessageType().getName().equals(Misc.CountedMap.getDescriptor().getName())) {
                HashMap map = Maps.newHashMap();
                for (Message m : messageList) {
                    Misc.CountedMap cm = (Misc.CountedMap)m;
                    Long curCount = (Long)map.get(cm.getKey());
                    map.put(cm.getKey(), (curCount == null ? 0L : curCount) + cm.getValue());
                }
                return map;
            }
            NonSpillableDataBag bag = new NonSpillableDataBag(messageList.size());
            for (Message m : messageList) {
                bag.add((Tuple)new ProtobufTuple(m));
            }
            return bag;
        }
        return new ProtobufTuple((Message)fieldValue);
    }

    protected Object singleFieldToTuple(Descriptors.FieldDescriptor fieldDescriptor, Object fieldValue) {
        assert (fieldDescriptor.getType() != Descriptors.FieldDescriptor.Type.MESSAGE) : "messageToFieldSchema called with field of type " + fieldDescriptor.getType();
        if (fieldDescriptor.isRepeated()) {
            List fieldValueList = fieldValue != null ? fieldValue : Collections.emptyList();
            NonSpillableDataBag bag = new NonSpillableDataBag(fieldValueList.size());
            for (Object singleFieldValue : fieldValueList) {
                Object nonEnumFieldValue = this.coerceToPigTypes(fieldDescriptor, singleFieldValue);
                Tuple innerTuple = tupleFactory_.newTuple(1);
                try {
                    innerTuple.set(0, nonEnumFieldValue);
                }
                catch (ExecException e) {
                    throw new RuntimeException(e);
                }
                bag.add(innerTuple);
            }
            return bag;
        }
        return this.coerceToPigTypes(fieldDescriptor, fieldValue);
    }

    private Object coerceToPigTypes(Descriptors.FieldDescriptor fieldDescriptor, Object fieldValue) {
        if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.ENUM && fieldValue != null) {
            Descriptors.EnumValueDescriptor enumValueDescriptor = (Descriptors.EnumValueDescriptor)fieldValue;
            return enumValueDescriptor.getName();
        }
        if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.BOOL && fieldValue != null) {
            Boolean boolValue = (Boolean)fieldValue;
            return new Integer(boolValue != false ? 1 : 0);
        }
        if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.BYTES && fieldValue != null) {
            ByteString bsValue = (ByteString)fieldValue;
            return new DataByteArray(bsValue.toByteArray());
        }
        return fieldValue;
    }

    public Schema toSchema(Descriptors.Descriptor msgDescriptor) {
        Schema schema = new Schema();
        try {
            for (Descriptors.FieldDescriptor fieldDescriptor : msgDescriptor.getFields()) {
                if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                    schema.add(this.messageToFieldSchema(fieldDescriptor));
                    continue;
                }
                schema.add(this.singleFieldToFieldSchema(fieldDescriptor));
            }
        }
        catch (FrontendException e) {
            LOG.warn("Could not convert descriptor " + msgDescriptor + " to schema", (Throwable)e);
        }
        return schema;
    }

    private Schema.FieldSchema messageToFieldSchema(Descriptors.FieldDescriptor fieldDescriptor) throws FrontendException {
        assert (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) : "messageToFieldSchema called with field of type " + fieldDescriptor.getType();
        if (this.coercionLevel_ == CoercionLevel.kAllowCoercionToPigMaps && fieldDescriptor.getMessageType().getName().equals(Misc.CountedMap.getDescriptor().getName()) && fieldDescriptor.isRepeated()) {
            return new Schema.FieldSchema(fieldDescriptor.getName(), null, 100);
        }
        Schema innerSchema = this.toSchema(fieldDescriptor.getMessageType());
        if (fieldDescriptor.isRepeated()) {
            Schema tupleSchema = new Schema();
            tupleSchema.add(new Schema.FieldSchema(fieldDescriptor.getName() + "_tuple", innerSchema, 110));
            return new Schema.FieldSchema(fieldDescriptor.getName(), tupleSchema, 120);
        }
        return new Schema.FieldSchema(fieldDescriptor.getName(), innerSchema, 110);
    }

    private Schema.FieldSchema singleFieldToFieldSchema(Descriptors.FieldDescriptor fieldDescriptor) throws FrontendException {
        assert (fieldDescriptor.getType() != Descriptors.FieldDescriptor.Type.MESSAGE) : "singleFieldToFieldSchema called with field of type " + fieldDescriptor.getType();
        if (fieldDescriptor.isRepeated()) {
            Schema itemSchema = new Schema();
            itemSchema.add(new Schema.FieldSchema(fieldDescriptor.getName(), null, this.getPigDataType(fieldDescriptor)));
            Schema itemTupleSchema = new Schema();
            itemTupleSchema.add(new Schema.FieldSchema(fieldDescriptor.getName() + "_tuple", itemSchema, 110));
            return new Schema.FieldSchema(fieldDescriptor.getName() + "_bag", itemTupleSchema, 120);
        }
        return new Schema.FieldSchema(fieldDescriptor.getName(), null, this.getPigDataType(fieldDescriptor));
    }

    private byte getPigDataType(Descriptors.FieldDescriptor fieldDescriptor) {
        switch (fieldDescriptor.getType()) {
            case INT32: 
            case UINT32: 
            case SINT32: 
            case FIXED32: 
            case SFIXED32: 
            case BOOL: {
                return 10;
            }
            case INT64: 
            case UINT64: 
            case SINT64: 
            case FIXED64: 
            case SFIXED64: {
                return 15;
            }
            case FLOAT: {
                return 20;
            }
            case DOUBLE: {
                return 25;
            }
            case STRING: 
            case ENUM: {
                return 55;
            }
            case BYTES: {
                return 50;
            }
            case MESSAGE: {
                throw new IllegalArgumentException("getPigDataType called on field " + fieldDescriptor.getFullName() + " of type message.");
            }
        }
        throw new IllegalArgumentException("Unexpected field type. " + fieldDescriptor.toString() + " " + fieldDescriptor.getFullName() + " " + fieldDescriptor.getType());
    }

    public String toPigScript(Descriptors.Descriptor msgDescriptor, String loaderClassName) {
        StringBuffer sb = new StringBuffer();
        int initialTabOffset = 3;
        sb.append("raw_data = load '$INPUT_FILES' using " + loaderClassName + "()").append("\n");
        sb.append(this.tabs(3)).append("as (").append("\n");
        sb.append(this.toPigScriptInternal(msgDescriptor, 3));
        sb.append(this.tabs(3)).append(");").append("\n").append("\n");
        return sb.toString();
    }

    public String toPigScript(Descriptors.Descriptor msgDescriptor, String loaderClassName, String ... params) {
        StringBuffer sb = new StringBuffer();
        int initialTabOffset = 3;
        sb.append("raw_data = load '$INPUT_FILES' using ").append(loaderClassName).append("(");
        String paramString = "";
        if (params.length > 0) {
            paramString = "'" + Joiner.on((String)",'").join((Object[])params) + "'";
        }
        sb.append(paramString).append(")").append("\n");
        sb.append("/**\n");
        sb.append(this.tabs(3)).append("as (").append("\n");
        sb.append(this.toPigScriptInternal(msgDescriptor, 3));
        sb.append(this.tabs(3)).append(")").append("\n").append("\n");
        sb.append("**/\n;\n");
        return sb.toString();
    }

    private StringBuffer toPigScriptInternal(Descriptors.Descriptor msgDescriptor, int numTabs) {
        StringBuffer sb = new StringBuffer();
        try {
            for (Descriptors.FieldDescriptor fieldDescriptor : msgDescriptor.getFields()) {
                boolean isLast;
                boolean bl = isLast = fieldDescriptor == msgDescriptor.getFields().get(msgDescriptor.getFields().size() - 1);
                if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                    sb.append(this.messageToPigScript(fieldDescriptor, numTabs + 1, isLast));
                    continue;
                }
                sb.append(this.singleFieldToPigScript(fieldDescriptor, numTabs + 1, isLast));
            }
        }
        catch (FrontendException e) {
            LOG.warn("Could not convert descriptor " + msgDescriptor + " to pig script", (Throwable)e);
        }
        return sb;
    }

    private StringBuffer messageToPigScript(Descriptors.FieldDescriptor fieldDescriptor, int numTabs, boolean isLast) throws FrontendException {
        assert (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) : "messageToPigScript called with field of type " + fieldDescriptor.getType();
        if (this.coercionLevel_ == CoercionLevel.kAllowCoercionToPigMaps && fieldDescriptor.getMessageType().getName().equals(Misc.CountedMap.getDescriptor().getName()) && fieldDescriptor.isRepeated()) {
            return new StringBuffer().append(this.tabs(numTabs)).append(fieldDescriptor.getName()).append(": map[]").append(isLast ? "" : ",").append("\n");
        }
        if (fieldDescriptor.isRepeated()) {
            return new StringBuffer().append(this.tabs(numTabs)).append(fieldDescriptor.getName()).append(": bag {").append("\n").append(this.tabs(numTabs + 1)).append(fieldDescriptor.getName()).append("_tuple: tuple (").append("\n").append(this.toPigScriptInternal(fieldDescriptor.getMessageType(), numTabs + 2)).append(this.tabs(numTabs + 1)).append(")").append("\n").append(this.tabs(numTabs)).append("}").append(isLast ? "" : ",").append("\n");
        }
        return new StringBuffer().append(this.tabs(numTabs)).append(fieldDescriptor.getName()).append(": tuple (").append("\n").append(this.toPigScriptInternal(fieldDescriptor.getMessageType(), numTabs + 1)).append(this.tabs(numTabs)).append(")").append(isLast ? "" : ",").append("\n");
    }

    private StringBuffer singleFieldToPigScript(Descriptors.FieldDescriptor fieldDescriptor, int numTabs, boolean isLast) throws FrontendException {
        assert (fieldDescriptor.getType() != Descriptors.FieldDescriptor.Type.MESSAGE) : "singleFieldToPigScript called with field of type " + fieldDescriptor.getType();
        if (fieldDescriptor.isRepeated()) {
            return new StringBuffer().append(this.tabs(numTabs)).append(fieldDescriptor.getName()).append("_bag: bag {").append("\n").append(this.tabs(numTabs + 1)).append(fieldDescriptor.getName()).append("_tuple: tuple (").append("\n").append(this.tabs(numTabs + 2)).append(fieldDescriptor.getName()).append(": ").append(this.getPigScriptDataType(fieldDescriptor)).append("\n").append(this.tabs(numTabs + 1)).append(")").append("\n").append(this.tabs(numTabs)).append("}").append(isLast ? "" : ",").append("\n");
        }
        return new StringBuffer().append(this.tabs(numTabs)).append(fieldDescriptor.getName()).append(": ").append(this.getPigScriptDataType(fieldDescriptor)).append(isLast ? "" : ",").append("\n");
    }

    private String getPigScriptDataType(Descriptors.FieldDescriptor fieldDescriptor) {
        switch (fieldDescriptor.getType()) {
            case INT32: 
            case UINT32: 
            case SINT32: 
            case FIXED32: 
            case SFIXED32: 
            case BOOL: {
                return "int";
            }
            case INT64: 
            case UINT64: 
            case SINT64: 
            case FIXED64: 
            case SFIXED64: {
                return "long";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
            case STRING: 
            case ENUM: {
                return "chararray";
            }
            case BYTES: {
                return "bytearray";
            }
            case MESSAGE: {
                throw new IllegalArgumentException("getPigScriptDataType called on field " + fieldDescriptor.getFullName() + " of type message.");
            }
        }
        throw new IllegalArgumentException("Unexpected field type. " + fieldDescriptor.toString() + " " + fieldDescriptor.getFullName() + " " + fieldDescriptor.getType());
    }

    private StringBuffer tabs(int numTabs) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < numTabs; ++i) {
            sb.append("  ");
        }
        return sb;
    }

    public static enum CoercionLevel {
        kNoCoercion,
        kAllowCoercionToPigMaps;

    }
}

