/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.store;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.twitter.elephantbird.mapreduce.output.LzoTextOutputFormat;
import com.twitter.elephantbird.pig.store.BaseStoreFunc;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.pig.data.Tuple;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LzoJsonStorage
extends BaseStoreFunc {
    private static final Logger LOG = LoggerFactory.getLogger(LzoJsonStorage.class);
    private final Set<String> keysToKeep_;
    private final JSONObject json = new JSONObject();

    public LzoJsonStorage() {
        this.keysToKeep_ = null;
        LOG.info("Initialized LzoJsonStorage. Keeping all keys.");
    }

    public LzoJsonStorage(String ... keysToKeep) {
        this.keysToKeep_ = Sets.newHashSet((Object[])keysToKeep);
        LOG.info("Initialized LzoJsonStorage. Keeping keys " + Joiner.on((String)", ").join(this.keysToKeep_) + ".");
    }

    public void putNext(Tuple tuple) throws IOException {
        this.json.clear();
        if (tuple != null && tuple.size() >= 1) {
            Map map = (Map)tuple.get(0);
            if (this.keysToKeep_ == null) {
                this.json.putAll(map);
            } else {
                for (Map.Entry entry : map.entrySet()) {
                    if (!this.keysToKeep_.contains(entry.getKey())) continue;
                    this.json.put(entry.getKey(), entry.getValue());
                }
            }
        }
        try {
            this.writer.write(null, (Object)new Text(this.json.toString()));
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public OutputFormat<NullWritable, Text> getOutputFormat() {
        return new LzoTextOutputFormat();
    }
}

