/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.load;

import com.google.common.collect.Lists;
import com.twitter.elephantbird.mapreduce.input.RawSequenceFileInputFormat;
import com.twitter.elephantbird.pig.load.LzoBaseLoadFunc;
import com.twitter.elephantbird.pig.util.SequenceFileConfig;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.pig.LoadCaster;
import org.apache.pig.LoadMetadata;
import org.apache.pig.LoadPushDown;
import org.apache.pig.ResourceSchema;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceFileLoader<K extends Writable, V extends Writable>
extends LzoBaseLoadFunc
implements LoadPushDown,
LoadMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(SequenceFileLoader.class);
    private final Config config;
    private final DataByteArray keyDataByteArray = new DataByteArray();
    private final DataByteArray valueDataByteArray = new DataByteArray();
    private final TupleFactory tupleFactory = TupleFactory.getInstance();
    private boolean readKey = true;
    private boolean readValue = true;

    public SequenceFileLoader(String keyArgs, String valueArgs, String otherArgs) throws ParseException, IOException {
        this.config = new Config(keyArgs, valueArgs, otherArgs);
    }

    public SequenceFileLoader(String keyArgs, String valueArgs) throws ParseException, IOException {
        this(keyArgs, valueArgs, "");
    }

    public SequenceFileLoader() throws ParseException, IOException {
        this("", "");
    }

    public InputFormat<DataInputBuffer, DataInputBuffer> getInputFormat() throws IOException {
        return new RawSequenceFileInputFormat();
    }

    public LoadCaster getLoadCaster() throws IOException {
        return null;
    }

    @Override
    public LoadPushDown.RequiredFieldResponse pushProjection(LoadPushDown.RequiredFieldList requiredFieldList) throws FrontendException {
        return this.pushProjectionHelper(requiredFieldList);
    }

    @Override
    public ResourceSchema getSchema(String location, Job job) throws IOException {
        ResourceSchema.ResourceFieldSchema keySchema = this.config.keyConverter.getLoadSchema();
        if (keySchema == null) {
            return null;
        }
        keySchema.setName("key");
        ResourceSchema.ResourceFieldSchema valueSchema = this.config.valueConverter.getLoadSchema();
        if (valueSchema == null) {
            return null;
        }
        valueSchema.setName("value");
        ResourceSchema resourceSchema = new ResourceSchema();
        resourceSchema.setFields(new ResourceSchema.ResourceFieldSchema[]{keySchema, valueSchema});
        return resourceSchema;
    }

    @Override
    public void setLocation(String location, Job job) throws IOException {
        super.setLocation(location, job);
        if (this.requiredFieldList != null) {
            this.readValue = false;
            this.readKey = false;
            block4: for (LoadPushDown.RequiredField field : this.requiredFieldList.getFields()) {
                int i = field.getIndex();
                switch (i) {
                    case 0: {
                        this.readKey = true;
                        continue block4;
                    }
                    case 1: {
                        this.readValue = true;
                        continue block4;
                    }
                }
                throw new FrontendException("Expected field index in [0, 1] but found index " + i);
            }
        }
    }

    public Tuple getNext() throws IOException {
        try {
            if (!this.reader.nextKeyValue()) {
                return null;
            }
            if (this.readKey) {
                if (this.readValue) {
                    return this.tupleFactory.newTupleNoCopy((List)Lists.newArrayList((Object[])new Object[]{this.getCurrentKeyObject(), this.getCurrentValueObject()}));
                }
                return this.tupleFactory.newTupleNoCopy((List)Lists.newArrayList((Object[])new Object[]{this.getCurrentKeyObject()}));
            }
            if (this.readValue) {
                return this.tupleFactory.newTupleNoCopy((List)Lists.newArrayList((Object[])new Object[]{this.getCurrentValueObject()}));
            }
            throw new IllegalStateException("Cowardly refusing to read zero fields per record");
        }
        catch (EOFException e) {
            if (!this.config.genericArguments.hasOption("skipEOFErrors")) {
                throw e;
            }
            LOG.warn("EOFException encountered while reading input", (Throwable)e);
            this.incrCounter(Error.EOFException, 1L);
        }
        catch (InterruptedException e) {
            throw new ExecException("Error while reading input", 6018, 16, (Throwable)e);
        }
        return null;
    }

    private Object getCurrentKeyObject() throws IOException, InterruptedException {
        DataInputBuffer ibuf = (DataInputBuffer)this.reader.getCurrentKey();
        this.keyDataByteArray.set(Arrays.copyOf(ibuf.getData(), ibuf.getLength()));
        return this.config.keyConverter.bytesToObject(this.keyDataByteArray);
    }

    private Object getCurrentValueObject() throws IOException, InterruptedException {
        DataInputBuffer ibuf = (DataInputBuffer)this.reader.getCurrentValue();
        this.valueDataByteArray.set(Arrays.copyOf(ibuf.getData(), ibuf.getLength()));
        return this.config.valueConverter.bytesToObject(this.valueDataByteArray);
    }

    private class Config
    extends SequenceFileConfig<K, V> {
        public static final String SKIP_EOF_ERRORS_PARAM = "skipEOFErrors";

        public Config(String keyArgs, String valueArgs, String genericArgs) throws ParseException, IOException {
            super(keyArgs, valueArgs, genericArgs);
        }

        @Override
        protected Options getGenericOptions() {
            OptionBuilder.withLongOpt((String)SKIP_EOF_ERRORS_PARAM);
            OptionBuilder.withDescription((String)"Skip EOFExceptions if they occur while reading data. Useful for reading sequence files while they are being created.");
            Option skipEOFOption = OptionBuilder.create();
            return super.getGenericOptions().addOption(skipEOFOption);
        }
    }

    public static enum Error {
        EOFException;

    }
}

