/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.load;

import com.google.protobuf.Message;
import com.twitter.elephantbird.mapreduce.input.MultiInputFormat;
import com.twitter.elephantbird.mapreduce.io.BinaryWritable;
import com.twitter.elephantbird.pig.load.LzoBaseLoadFunc;
import com.twitter.elephantbird.pig.util.PigUtil;
import com.twitter.elephantbird.pig.util.ProjectedProtobufTupleFactory;
import com.twitter.elephantbird.pig.util.ProtobufToPig;
import com.twitter.elephantbird.util.Protobufs;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.pig.LoadPushDown;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufPigLoader<M extends Message>
extends LzoBaseLoadFunc {
    static final Logger LOG = LoggerFactory.getLogger(ProtobufPigLoader.class);
    protected TypeRef<M> typeRef = null;
    private final ProtobufToPig protoToPig = new ProtobufToPig();
    private ProjectedProtobufTupleFactory<M> tupleTemplate = null;

    public ProtobufPigLoader(String protoClassName) {
        this.typeRef = PigUtil.getProtobufTypeRef(protoClassName);
    }

    @Override
    public LoadPushDown.RequiredFieldResponse pushProjection(LoadPushDown.RequiredFieldList requiredFieldList) throws FrontendException {
        return this.pushProjectionHelper(requiredFieldList);
    }

    public Tuple getNext() throws IOException {
        Message value;
        if (this.tupleTemplate == null) {
            this.tupleTemplate = new ProjectedProtobufTupleFactory<M>(this.typeRef, this.requiredFieldList);
        }
        return (value = (Message)this.getNextBinaryValue(this.typeRef)) != null ? this.tupleTemplate.newTuple(value) : null;
    }

    @Override
    public ResourceSchema getSchema(String filename, Job job) throws IOException {
        return new ResourceSchema(this.protoToPig.toSchema(Protobufs.getMessageDescriptor((Class)this.typeRef.getRawClass())));
    }

    public InputFormat<LongWritable, BinaryWritable<M>> getInputFormat() throws IOException {
        if (this.typeRef == null) {
            LOG.error("Protobuf class must be specified before an InputFormat can be created. Do not use the no-argument constructor.");
            throw new IllegalArgumentException("Protobuf class must be specified before an InputFormat can be created. Do not use the no-argument constructor.");
        }
        return new MultiInputFormat(this.typeRef);
    }
}

