/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.load;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.pig.Expression;
import org.apache.pig.LoadCaster;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.LoadPushDown;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;

public class FilterLoadFunc
extends LoadFunc
implements LoadMetadata,
LoadPushDown {
    protected LoadFunc loader;

    public FilterLoadFunc(LoadFunc loader) {
        this.loader = loader;
    }

    public void setLoader(LoadFunc loader) {
        this.loader = loader;
    }

    private boolean isSet() {
        return this.loader != null;
    }

    public InputFormat getInputFormat() throws IOException {
        return this.isSet() ? this.loader.getInputFormat() : null;
    }

    public LoadCaster getLoadCaster() throws IOException {
        return this.isSet() ? this.loader.getLoadCaster() : null;
    }

    public Tuple getNext() throws IOException {
        return this.isSet() ? this.loader.getNext() : null;
    }

    public void prepareToRead(RecordReader reader, PigSplit split) throws IOException {
        if (this.isSet()) {
            this.loader.prepareToRead(reader, split);
        }
    }

    public String relativeToAbsolutePath(String location, Path curDir) throws IOException {
        return this.isSet() ? this.loader.relativeToAbsolutePath(location, curDir) : super.relativeToAbsolutePath(location, curDir);
    }

    public void setLocation(String location, Job job) throws IOException {
        if (this.isSet()) {
            this.loader.setLocation(location, job);
        }
    }

    public void setUDFContextSignature(String signature) {
        if (this.isSet()) {
            this.loader.setUDFContextSignature(signature);
        } else {
            super.setUDFContextSignature(signature);
        }
    }

    private static LoadMetadata asLoadMetadata(LoadFunc loader) {
        return loader instanceof LoadMetadata ? (LoadMetadata)loader : null;
    }

    private static LoadPushDown asLoadPushDown(LoadFunc loader) {
        return loader instanceof LoadPushDown ? (LoadPushDown)loader : null;
    }

    public String[] getPartitionKeys(String location, Job job) throws IOException {
        LoadMetadata metadata = FilterLoadFunc.asLoadMetadata(this.loader);
        return metadata == null ? null : metadata.getPartitionKeys(location, job);
    }

    public ResourceSchema getSchema(String location, Job job) throws IOException {
        LoadMetadata metadata = FilterLoadFunc.asLoadMetadata(this.loader);
        return metadata == null ? null : metadata.getSchema(location, job);
    }

    public ResourceStatistics getStatistics(String location, Job job) throws IOException {
        LoadMetadata metadata = FilterLoadFunc.asLoadMetadata(this.loader);
        return metadata == null ? null : metadata.getStatistics(location, job);
    }

    public void setPartitionFilter(Expression partitionFilter) throws IOException {
        LoadMetadata metadata = FilterLoadFunc.asLoadMetadata(this.loader);
        if (metadata != null) {
            metadata.setPartitionFilter(partitionFilter);
        }
    }

    public List<LoadPushDown.OperatorSet> getFeatures() {
        LoadPushDown pushDown = FilterLoadFunc.asLoadPushDown(this.loader);
        return pushDown == null ? null : pushDown.getFeatures();
    }

    public LoadPushDown.RequiredFieldResponse pushProjection(LoadPushDown.RequiredFieldList requiredFieldList) throws FrontendException {
        LoadPushDown pushDown = FilterLoadFunc.asLoadPushDown(this.loader);
        return pushDown == null ? null : pushDown.pushProjection(requiredFieldList);
    }
}

