/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

final class PSDGlobalLayerMask {
    static final PSDGlobalLayerMask NULL_MASK = new PSDGlobalLayerMask();
    final int colorSpace;
    final short[] colors = new short[4];
    final int opacity;
    final int kind;

    PSDGlobalLayerMask(ImageInputStream imageInputStream, long l) throws IOException {
        this.colorSpace = imageInputStream.readUnsignedShort();
        imageInputStream.readFully(this.colors, 0, this.colors.length);
        this.opacity = imageInputStream.readUnsignedShort();
        this.kind = imageInputStream.readUnsignedByte();
        imageInputStream.skipBytes(l - 17L);
    }

    private PSDGlobalLayerMask() {
        this.colorSpace = 0;
        this.opacity = 0;
        this.kind = 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        stringBuilder.append("[");
        stringBuilder.append("color space: 0x").append(Integer.toHexString(this.colorSpace));
        stringBuilder.append(", colors: [");
        for (int i = 0; i < this.colors.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("0x").append(Integer.toHexString(this.colors[i]));
        }
        stringBuilder.append("], opacity: ").append(this.opacity);
        stringBuilder.append(", kind: ").append(this.kind);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

