/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.metadata.exif;

import com.twelvemonkeys.imageio.metadata.CompoundDirectory;
import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.Entry;
import com.twelvemonkeys.imageio.metadata.exif.EXIFEntry;
import com.twelvemonkeys.imageio.metadata.exif.EXIFReader;
import com.twelvemonkeys.imageio.metadata.exif.IFD;
import com.twelvemonkeys.imageio.metadata.exif.Rational;
import com.twelvemonkeys.lang.Validate;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageOutputStream;

public class EXIFWriter {
    static final int WORD_LENGTH = 2;
    static final int LONGWORD_LENGTH = 4;
    static final int ENTRY_LENGTH = 12;

    public boolean write(Collection<Entry> collection, ImageOutputStream imageOutputStream) throws IOException {
        return this.write(new IFD(collection), imageOutputStream);
    }

    public boolean write(Directory directory, ImageOutputStream imageOutputStream) throws IOException {
        Validate.notNull((Object)directory);
        Validate.notNull((Object)imageOutputStream);
        this.writeTIFFHeader(imageOutputStream);
        if (directory instanceof CompoundDirectory) {
            CompoundDirectory compoundDirectory = (CompoundDirectory)directory;
            for (int i = 0; i < compoundDirectory.directoryCount(); ++i) {
                this.writeIFD(compoundDirectory.getDirectory(i), imageOutputStream, false);
            }
        } else {
            this.writeIFD(directory, imageOutputStream, false);
        }
        imageOutputStream.writeInt(0);
        return true;
    }

    public void writeTIFFHeader(ImageOutputStream imageOutputStream) throws IOException {
        ByteOrder byteOrder = imageOutputStream.getByteOrder();
        imageOutputStream.writeShort(byteOrder == ByteOrder.BIG_ENDIAN ? 19789 : 18761);
        imageOutputStream.writeShort(42);
    }

    public long writeIFD(Collection<Entry> collection, ImageOutputStream imageOutputStream) throws IOException {
        return this.writeIFD(new IFD(collection), imageOutputStream, false);
    }

    private long writeIFD(Directory directory, ImageOutputStream imageOutputStream, boolean bl) throws IOException {
        Directory directory2 = this.ensureOrderedDirectory(directory);
        long l = imageOutputStream.getStreamPosition();
        long l2 = this.computeDataSize(directory2);
        long l3 = imageOutputStream.getStreamPosition() + l2 + 4L;
        if (!bl) {
            imageOutputStream.writeInt(this.assertIntegerOffset(l3));
            l += 4L;
            imageOutputStream.seek(l3);
        } else {
            l += (long)(2 + directory2.size() * 12);
        }
        imageOutputStream.writeShort(directory2.size());
        for (Entry entry : directory2) {
            imageOutputStream.writeShort((Integer)entry.getIdentifier());
            imageOutputStream.writeShort(this.getType(entry));
            imageOutputStream.writeInt(this.getCount(entry));
            if (entry.getValue() instanceof Directory) {
                imageOutputStream.writeInt(this.assertIntegerOffset(l));
                long l4 = imageOutputStream.getStreamPosition();
                imageOutputStream.seek(l);
                Directory directory3 = (Directory)entry.getValue();
                this.writeIFD(directory3, imageOutputStream, true);
                l += this.computeDataSize(directory3);
                imageOutputStream.seek(l4);
                continue;
            }
            l += this.writeValue(entry, l, imageOutputStream);
        }
        return l3;
    }

    public long computeIFDSize(Collection<Entry> collection) {
        return 2L + this.computeDataSize(new IFD(collection)) + (long)(collection.size() * 12);
    }

    private long computeDataSize(Directory directory) {
        long l = 0L;
        for (Entry entry : directory) {
            int n = EXIFReader.getValueLength(this.getType(entry), this.getCount(entry));
            if (n < 0) {
                throw new IllegalArgumentException(String.format("Unknown size for entry %s", entry));
            }
            if (n > 4) {
                l += (long)n;
            }
            if (!(entry.getValue() instanceof Directory)) continue;
            Directory directory2 = (Directory)entry.getValue();
            long l2 = (long)(2 + directory2.size() * 12) + this.computeDataSize(directory2);
            l += l2;
        }
        return l;
    }

    private Directory ensureOrderedDirectory(Directory directory) {
        if (!this.isSorted(directory)) {
            ArrayList<Entry> arrayList = new ArrayList<Entry>(directory.size());
            for (Entry entry : directory) {
                arrayList.add(entry);
            }
            Collections.sort(arrayList, new Comparator<Entry>(){

                @Override
                public int compare(Entry entry, Entry entry2) {
                    return (Integer)entry.getIdentifier() - (Integer)entry2.getIdentifier();
                }
            });
            return new IFD(arrayList);
        }
        return directory;
    }

    private boolean isSorted(Directory directory) {
        int n = 0;
        for (Entry entry : directory) {
            int n2 = (Integer)entry.getIdentifier() & 0xFFFF;
            if (n2 < n) {
                return false;
            }
            n = n2;
        }
        return true;
    }

    private long writeValue(Entry entry, long l, ImageOutputStream imageOutputStream) throws IOException {
        short s = this.getType(entry);
        int n = EXIFReader.getValueLength(s, this.getCount(entry));
        if (n <= 4) {
            this.writeValueInline(entry.getValue(), s, imageOutputStream);
            for (int i = n; i < 4; ++i) {
                imageOutputStream.write(0);
            }
            return 0L;
        }
        this.writeValueAt(l, entry.getValue(), s, imageOutputStream);
        return n;
    }

    private int getCount(Entry entry) {
        Object object = entry.getValue();
        return object instanceof String ? ((String)object).getBytes(Charset.forName("UTF-8")).length + 1 : entry.valueCount();
    }

    private void writeValueInline(Object object, short s, ImageOutputStream imageOutputStream) throws IOException {
        if (object.getClass().isArray()) {
            switch (s) {
                case 1: {
                    imageOutputStream.write((byte[])object);
                    break;
                }
                case 3: {
                    short[] sArray;
                    if (object instanceof short[]) {
                        sArray = (short[])object;
                    } else if (object instanceof int[]) {
                        int[] nArray = (int[])object;
                        sArray = new short[nArray.length];
                        for (int i = 0; i < nArray.length; ++i) {
                            sArray[i] = (short)nArray[i];
                        }
                    } else if (object instanceof long[]) {
                        long[] lArray = (long[])object;
                        sArray = new short[lArray.length];
                        for (int i = 0; i < lArray.length; ++i) {
                            sArray[i] = (short)lArray[i];
                        }
                    } else {
                        throw new IllegalArgumentException("Unsupported type for TIFF SHORT: " + object.getClass());
                    }
                    imageOutputStream.writeShorts(sArray, 0, sArray.length);
                    break;
                }
                case 4: {
                    int[] nArray;
                    if (object instanceof int[]) {
                        nArray = (int[])object;
                    } else if (object instanceof long[]) {
                        long[] lArray = (long[])object;
                        nArray = new int[lArray.length];
                        for (int i = 0; i < lArray.length; ++i) {
                            nArray[i] = (int)lArray[i];
                        }
                    } else {
                        throw new IllegalArgumentException("Unsupported type for TIFF SHORT: " + object.getClass());
                    }
                    imageOutputStream.writeInts(nArray, 0, nArray.length);
                    break;
                }
                case 5: {
                    Rational[] rationalArray;
                    for (Rational rational : rationalArray = (Rational[])object) {
                        imageOutputStream.writeInt((int)rational.numerator());
                        imageOutputStream.writeInt((int)rational.denominator());
                    }
                }
                default: {
                    throw new IllegalArgumentException("Unsupported TIFF type: " + s);
                }
            }
        } else {
            switch (s) {
                case 1: {
                    imageOutputStream.writeByte((Integer)object);
                    break;
                }
                case 2: {
                    byte[] byArray = ((String)object).getBytes(Charset.forName("UTF-8"));
                    imageOutputStream.write(byArray);
                    imageOutputStream.write(0);
                    break;
                }
                case 3: {
                    imageOutputStream.writeShort((Integer)object);
                    break;
                }
                case 4: {
                    imageOutputStream.writeInt(((Number)object).intValue());
                    break;
                }
                case 5: {
                    Rational rational = (Rational)object;
                    imageOutputStream.writeInt((int)rational.numerator());
                    imageOutputStream.writeInt((int)rational.denominator());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported TIFF type: " + s);
                }
            }
        }
    }

    private void writeValueAt(long l, Object object, short s, ImageOutputStream imageOutputStream) throws IOException {
        imageOutputStream.writeInt(this.assertIntegerOffset(l));
        long l2 = imageOutputStream.getStreamPosition();
        imageOutputStream.seek(l);
        this.writeValueInline(object, s, imageOutputStream);
        imageOutputStream.seek(l2);
    }

    private short getType(Entry entry) {
        if (entry instanceof EXIFEntry) {
            EXIFEntry eXIFEntry = (EXIFEntry)entry;
            return eXIFEntry.getType();
        }
        Object object = Validate.notNull((Object)entry.getValue());
        boolean bl = object.getClass().isArray();
        if (bl) {
            object = Array.get(object, 0);
        }
        if (object instanceof Byte) {
            return 1;
        }
        if (object instanceof Short) {
            if (!bl && (Short)object < 127) {
                return 1;
            }
            return 3;
        }
        if (object instanceof Integer) {
            if (!bl && (Integer)object < Short.MAX_VALUE) {
                return 3;
            }
            return 4;
        }
        if (object instanceof Long && !bl && (Long)object < Integer.MAX_VALUE) {
            return 4;
        }
        if (object instanceof Rational) {
            return 5;
        }
        if (object instanceof String) {
            return 2;
        }
        throw new UnsupportedOperationException(String.format("Method getType not implemented for entry of type %s/value of type %s", entry.getClass(), object.getClass()));
    }

    private int assertIntegerOffset(long l) throws IIOException {
        if (l > 0xFFFFFFFFL) {
            throw new IIOException("Integer overflow for TIFF stream");
        }
        return (int)l;
    }
}

