/*
 * Decompiled with CFR 0.152.
 */
package com.truelayer.signing;

import com.nimbusds.jose.JOSEObject;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.util.Base64URL;
import com.truelayer.signing.HeaderName;
import com.truelayer.signing.SignatureException;
import com.truelayer.signing.Utils;
import com.truelayer.signing.Verifier;
import java.security.interfaces.ECPublicKey;
import java.util.Map;

class VerifierFromJwks
extends Verifier {
    private final JWKSet jwkSet;

    protected VerifierFromJwks(JWKSet jwkSet) {
        this.jwkSet = jwkSet;
    }

    @Override
    public void verify(String signature) {
        JWSHeader jwsHeader = SignatureException.evaluate(() -> JWSHeader.parse((Base64URL)JOSEObject.split((String)signature)[0]));
        Map<HeaderName, String> orderedHeaders = this.validateSignatureHeader(jwsHeader);
        String keyID = jwsHeader.getKeyID();
        SignatureException.ensure(keyID != null, "missing kid");
        JWK keyByKeyId = this.jwkSet.getKeyByKeyId(keyID);
        SignatureException.ensure(keyByKeyId != null, "no jwk found with kid");
        ECPublicKey publicKey = this.buildPublicKey(keyByKeyId);
        Boolean verifiedResult = SignatureException.evaluate(() -> JWSObject.parse((String)signature, (Payload)new Payload(Utils.buildPayload(orderedHeaders, this.method, this.path, this.body))).verify((JWSVerifier)new ECDSAVerifier(publicKey)));
        if (!verifiedResult.booleanValue()) {
            String path2 = this.path.endsWith("/") ? this.path.substring(0, this.path.length() - 1) : this.path + "/";
            verifiedResult = SignatureException.evaluate(() -> JWSObject.parse((String)signature, (Payload)new Payload(Utils.buildPayload(orderedHeaders, this.method, path2, this.body))).verify((JWSVerifier)new ECDSAVerifier(publicKey)));
        }
        SignatureException.ensure(verifiedResult, "invalid signature");
    }

    private ECPublicKey buildPublicKey(JWK keyByKeyId) {
        return SignatureException.evaluate(() -> {
            ECKey ecKey = keyByKeyId.toECKey();
            SignatureException.ensure(ecKey.getKeyType().getValue().equals("EC"), "unsupported jwk.kty");
            SignatureException.ensure(ecKey.getCurve().equals((Object)Curve.P_521), "unsupported jwk.crv");
            return ecKey.toECPublicKey();
        });
    }
}

