/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.java.junit.dataprovider.internal;

import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.common.Preconditions;
import com.tngtech.java.junit.dataprovider.internal.convert.ObjectArrayConverter;
import com.tngtech.java.junit.dataprovider.internal.convert.SingleArgConverter;
import com.tngtech.java.junit.dataprovider.internal.convert.StringConverter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class DataConverter {
    private ObjectArrayConverter objectArrayConverter = new ObjectArrayConverter();
    private SingleArgConverter singleArgConverter = new SingleArgConverter();
    private StringConverter stringConverter = new StringConverter();

    public boolean canConvert(Type type) {
        ParameterizedType parameterizedType;
        Type rawType;
        if (type instanceof Class) {
            return Object[][].class.equals((Object)type) || Object[].class.equals((Object)type) || String[].class.equals((Object)type);
        }
        if (type instanceof ParameterizedType && Iterable.class.isAssignableFrom((Class)(rawType = (parameterizedType = (ParameterizedType)type).getRawType()))) {
            return this.canConvertIterableOf(parameterizedType);
        }
        return false;
    }

    public List<Object[]> convert(Object data, boolean isVarArgs, Class<?>[] parameterTypes, DataProvider dataProvider) {
        Preconditions.checkNotNull(parameterTypes, "parameterTypes must not be null");
        Preconditions.checkNotNull(dataProvider, "dataProvider must not be null");
        Preconditions.checkArgument(parameterTypes.length != 0, "parameterTypes must not be empty");
        if (data instanceof Object[][]) {
            return this.convert((Object[][])data, isVarArgs, parameterTypes);
        }
        if (data instanceof String[]) {
            return this.convert((String[])data, isVarArgs, parameterTypes, dataProvider);
        }
        if (data instanceof Object[]) {
            return this.convert((Object[])data, isVarArgs, parameterTypes);
        }
        if (data instanceof Iterable) {
            Iterable iterableData = (Iterable)data;
            return this.convert(iterableData, isVarArgs, parameterTypes);
        }
        throw new ClassCastException(String.format("Cannot cast to either Object[][], Object[], String[], or Iterable because data was: %s", data));
    }

    private boolean canConvertIterableOf(ParameterizedType parameterizedType) {
        if (parameterizedType.getActualTypeArguments().length == 1) {
            Type innerType = parameterizedType.getActualTypeArguments()[0];
            if (parameterizedType.getActualTypeArguments()[0] instanceof ParameterizedType) {
                ParameterizedType innerType2 = (ParameterizedType)innerType;
                return Iterable.class.isAssignableFrom((Class)innerType2.getRawType());
            }
            return true;
        }
        return false;
    }

    private List<Object[]> convert(Object[][] data, boolean isVarArgs, Class<?>[] parameterTypes) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (Object[] arguments : data) {
            result.add(this.objectArrayConverter.convert(arguments, isVarArgs, parameterTypes));
        }
        return result;
    }

    private List<Object[]> convert(String[] data, boolean isVarArgs, Class<?>[] parameterTypes, DataProvider dataProvider) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        int idx = 0;
        for (String argString : data) {
            result.add(this.stringConverter.convert(argString, isVarArgs, parameterTypes, dataProvider, idx++));
        }
        return result;
    }

    private List<Object[]> convert(Object[] data, boolean isVarArgs, Class<?>[] parameterTypes) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (Object argument : data) {
            result.add(this.singleArgConverter.convert(argument, isVarArgs, parameterTypes));
        }
        return result;
    }

    private List<Object[]> convert(Iterable<?> data, boolean isVarArgs, Class<?>[] parameterTypes) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (Object arguments : data) {
            if (arguments != null && Iterable.class.isAssignableFrom(arguments.getClass())) {
                Iterable iterable = (Iterable)arguments;
                result.add(this.objectArrayConverter.convert(this.toArray(iterable), isVarArgs, parameterTypes));
                continue;
            }
            result.add(this.singleArgConverter.convert(arguments, isVarArgs, parameterTypes));
        }
        return result;
    }

    private Object[] toArray(Iterable<?> iterable) {
        ArrayList list = new ArrayList();
        for (Object element : iterable) {
            list.add(element);
        }
        return list.toArray();
    }

    public void setObjectArrayConverter(ObjectArrayConverter objectArrayConverter) {
        this.objectArrayConverter = objectArrayConverter;
    }

    public void setSingleArgConverter(SingleArgConverter singleArgConverter) {
        this.singleArgConverter = singleArgConverter;
    }

    public void setStringConverter(StringConverter stringConverter) {
        this.stringConverter = stringConverter;
    }
}

