/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.junit.internal;

import com.tngtech.archunit.base.ArchUnitException;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ReflectionUtils {
    private ReflectionUtils() {
    }

    static Set<Class<?>> getAllSupertypes(Class<?> type) {
        if (type == null) {
            return Collections.emptySet();
        }
        ImmutableSet.Builder result = ImmutableSet.builder().add(type).addAll(ReflectionUtils.getAllSupertypes(type.getSuperclass()));
        for (Class<?> c : type.getInterfaces()) {
            result.addAll(ReflectionUtils.getAllSupertypes(c));
        }
        return result.build();
    }

    static Collection<Field> getAllFields(Class<?> owner, Predicate<? super Field> predicate) {
        return ReflectionUtils.getAll(owner, Class::getDeclaredFields).filter(predicate).collect(Collectors.toList());
    }

    static Collection<Method> getAllMethods(Class<?> owner, Predicate<? super Method> predicate) {
        return ReflectionUtils.getAll(owner, Class::getDeclaredMethods).filter(predicate).collect(Collectors.toList());
    }

    private static <T> Stream<T> getAll(Class<?> type, Function<Class<?>, T[]> collector) {
        Stream.Builder result = Stream.builder();
        for (Class<?> t : ReflectionUtils.getAllSupertypes(type)) {
            Arrays.stream(collector.apply(t)).forEach(result);
        }
        return result.build();
    }

    static <T> T newInstanceOf(Class<T> type) {
        return (T)com.tngtech.archunit.base.ReflectionUtils.newInstanceOf(type, (Object[])new Object[0]);
    }

    private static <T> T getValue(Field field, Object owner) {
        try {
            field.setAccessible(true);
            return (T)field.get(owner);
        }
        catch (IllegalAccessException e) {
            throw new ArchUnitException.ReflectionException((Throwable)e);
        }
    }

    static <T> T getValueOrThrowException(Field field, Class<?> fieldOwner, Function<Throwable, ? extends RuntimeException> exceptionConverter) {
        try {
            if (Modifier.isStatic(field.getModifiers())) {
                return ReflectionUtils.getValue(field, null);
            }
            return ReflectionUtils.getValue(field, ReflectionUtils.newInstanceOf(fieldOwner));
        }
        catch (ArchUnitException.ReflectionException e) {
            throw exceptionConverter.apply(e.getCause());
        }
    }

    static <T> T invokeMethod(Method method, Class<?> methodOwner, Object ... args) {
        if (Modifier.isStatic(method.getModifiers())) {
            return ReflectionUtils.invoke(null, method, args);
        }
        return ReflectionUtils.invoke(ReflectionUtils.newInstanceOf(methodOwner), method, args);
    }

    private static <T> T invoke(Object owner, Method method, Object ... args) {
        method.setAccessible(true);
        try {
            return (T)method.invoke(owner, args);
        }
        catch (IllegalAccessException e) {
            throw new ArchUnitException.ReflectionException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            ReflectionUtils.rethrowUnchecked(e.getTargetException());
            return null;
        }
    }

    private static <T extends Throwable> void rethrowUnchecked(Throwable throwable) throws T {
        throw throwable;
    }

    static Predicate<AnnotatedElement> withAnnotation(Class<? extends Annotation> annotationType) {
        return input -> input.isAnnotationPresent(annotationType);
    }
}

