/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.junit;

import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.importer.ClassFileImporter;
import com.tngtech.archunit.core.importer.ImportOption;
import com.tngtech.archunit.core.importer.ImportOptions;
import com.tngtech.archunit.core.importer.Location;
import com.tngtech.archunit.core.importer.Locations;
import com.tngtech.archunit.junit.ArchTestExecutionException;
import com.tngtech.archunit.junit.CacheMode;
import com.tngtech.archunit.junit.ClassAnalysisRequest;
import com.tngtech.archunit.junit.LocationProvider;
import com.tngtech.archunit.junit.ReflectionUtils;
import com.tngtech.archunit.thirdparty.com.google.common.annotations.VisibleForTesting;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.cache.CacheBuilder;
import com.tngtech.archunit.thirdparty.com.google.common.cache.CacheLoader;
import com.tngtech.archunit.thirdparty.com.google.common.cache.LoadingCache;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class ClassCache {
    @VisibleForTesting
    final Map<Class<?>, JavaClasses> cachedByTest = new ConcurrentHashMap();
    @VisibleForTesting
    final LoadingCache<LocationsKey, LazyJavaClasses> cachedByLocations = CacheBuilder.newBuilder().softValues().build((CacheLoader)new CacheLoader<LocationsKey, LazyJavaClasses>(){

        public LazyJavaClasses load(LocationsKey key) {
            return new LazyJavaClasses(key.locations, key.importOptionTypes);
        }
    });
    private CacheClassFileImporter cacheClassFileImporter = new CacheClassFileImporter();

    ClassCache() {
    }

    JavaClasses getClassesToAnalyzeFor(Class<?> testClass, ClassAnalysisRequest classAnalysisRequest) {
        Preconditions.checkNotNull(testClass);
        Preconditions.checkNotNull((Object)classAnalysisRequest);
        if (this.cachedByTest.containsKey(testClass)) {
            return this.cachedByTest.get(testClass);
        }
        LocationsKey locations = RequestedLocations.by(classAnalysisRequest, testClass).asKey();
        JavaClasses classes = classAnalysisRequest.getCacheMode() == CacheMode.FOREVER ? ((LazyJavaClasses)this.cachedByLocations.getUnchecked((Object)locations)).get() : new LazyJavaClasses(locations.locations, locations.importOptionTypes).get();
        this.cachedByTest.put(testClass, classes);
        return classes;
    }

    void clear(Class<?> testClass) {
        this.cachedByTest.remove(testClass);
    }

    static class CacheClassFileImporter {
        CacheClassFileImporter() {
        }

        JavaClasses importClasses(ImportOptions importOptions, Collection<Location> locations) {
            return new ClassFileImporter(importOptions).importLocations(locations);
        }
    }

    private static abstract class RequestedLocations {
        private RequestedLocations() {
        }

        abstract LocationsKey asKey();

        public static RequestedLocations by(ClassAnalysisRequest classAnalysisRequest, Class<?> testClass) {
            return RequestedLocations.noSpecificLocationRequested(classAnalysisRequest) ? new All(classAnalysisRequest.getImportOptions()) : new Specific(classAnalysisRequest, testClass);
        }

        private static boolean noSpecificLocationRequested(ClassAnalysisRequest classAnalysisRequest) {
            return classAnalysisRequest.getPackageNames().length == 0 && classAnalysisRequest.getPackageRoots().length == 0 && classAnalysisRequest.getLocationProviders().length == 0;
        }

        private static class All
        extends RequestedLocations {
            private Class<? extends ImportOption>[] importOptions;

            private All(Class<? extends ImportOption>[] importOptions) {
                this.importOptions = importOptions;
            }

            @Override
            LocationsKey asKey() {
                return new LocationsKey(this.importOptions, Locations.inClassPath());
            }
        }

        private static class Specific
        extends RequestedLocations {
            private final ClassAnalysisRequest classAnalysisRequest;
            private final Set<Location> declaredLocations;

            private Specific(ClassAnalysisRequest classAnalysisRequest, Class<?> testClass) {
                this.classAnalysisRequest = classAnalysisRequest;
                this.declaredLocations = ImmutableSet.builder().addAll(this.getLocationsOfPackages()).addAll(this.getLocationsOfProviders(testClass)).build();
            }

            private Set<Location> getLocationsOfPackages() {
                ImmutableSet packages = ImmutableSet.builder().add((Object[])this.classAnalysisRequest.getPackageNames()).addAll(this.toPackageStrings(this.classAnalysisRequest.getPackageRoots())).build();
                return this.locationsOf((Set<String>)packages);
            }

            private Set<Location> getLocationsOfProviders(Class<?> testClass) {
                HashSet<Location> result = new HashSet<Location>();
                for (Class<? extends LocationProvider> providerClass : this.classAnalysisRequest.getLocationProviders()) {
                    result.addAll(this.tryCreate(providerClass).get(testClass));
                }
                return result;
            }

            private LocationProvider tryCreate(Class<? extends LocationProvider> providerClass) {
                try {
                    return ReflectionUtils.newInstanceOf(providerClass);
                }
                catch (RuntimeException e) {
                    String message = String.format("Failed to create %s. It must be accessible and provide a public default constructor", providerClass.getSimpleName());
                    throw new ArchTestExecutionException(message, e);
                }
            }

            private Set<String> toPackageStrings(Class<?>[] classes) {
                ImmutableSet.Builder result = ImmutableSet.builder();
                for (Class<?> clazz : classes) {
                    result.add((Object)clazz.getPackage().getName());
                }
                return result.build();
            }

            private Set<Location> locationsOf(Set<String> packages) {
                HashSet<Location> result = new HashSet<Location>();
                for (String pkg : packages) {
                    result.addAll(Locations.ofPackage((String)pkg));
                }
                return result;
            }

            @Override
            LocationsKey asKey() {
                return new LocationsKey(this.classAnalysisRequest.getImportOptions(), this.declaredLocations);
            }
        }
    }

    private static class LocationsKey {
        private final Set<Class<? extends ImportOption>> importOptionTypes;
        private final Set<Location> locations;

        private LocationsKey(Class<? extends ImportOption>[] importOptionTypes, Set<Location> locations) {
            this.importOptionTypes = ImmutableSet.copyOf((Object[])importOptionTypes);
            this.locations = locations;
        }

        public int hashCode() {
            return Objects.hash(this.importOptionTypes, this.locations);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            LocationsKey other = (LocationsKey)obj;
            return Objects.equals(this.importOptionTypes, other.importOptionTypes) && Objects.equals(this.locations, other.locations);
        }
    }

    private class LazyJavaClasses {
        private final Set<Location> locations;
        private final Set<Class<? extends ImportOption>> importOptionTypes;
        private volatile JavaClasses javaClasses;

        private LazyJavaClasses(Set<Location> locations, Set<Class<? extends ImportOption>> importOptionTypes) {
            this.locations = locations;
            this.importOptionTypes = importOptionTypes;
        }

        public JavaClasses get() {
            if (this.javaClasses == null) {
                this.initialize();
            }
            return this.javaClasses;
        }

        private synchronized void initialize() {
            if (this.javaClasses == null) {
                ImportOptions importOptions = new ImportOptions();
                for (Class<? extends ImportOption> optionClass : this.importOptionTypes) {
                    importOptions = importOptions.with(ReflectionUtils.newInstanceOf(optionClass));
                }
                this.javaClasses = ClassCache.this.cacheClassFileImporter.importClasses(importOptions, this.locations);
            }
        }
    }
}

