/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbeetle;

import com.tigerbeetle.AssertionError;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;

final class JNILoader {
    public static final String libName = "tb_jniclient";

    private JNILoader() {
    }

    public static void loadFromJar() {
        File temp;
        Arch arch = Arch.getArch();
        OS os = OS.getOS();
        Abi abi = Abi.getAbi(os);
        String jniResourcesPath = JNILoader.getResourcesPath(arch, os, abi);
        String fileName = Paths.get(jniResourcesPath, new String[0]).getFileName().toString();
        try (InputStream stream = JNILoader.class.getResourceAsStream(jniResourcesPath);){
            if (stream == null) {
                System.loadLibrary(libName);
                return;
            }
            temp = Files.createTempFile(fileName, "", new FileAttribute[0]).toFile();
            Files.copy(stream, temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ioException) {
            throw new AssertionError(ioException, "TigerBeetle jni %s could not be extracted from jar.", fileName);
        }
        System.load(temp.getAbsolutePath());
        temp.deleteOnExit();
    }

    static String getResourcesPath(Arch arch, OS os, Abi abi) {
        String jniResources = String.format("/lib/%s-%s", new Object[]{arch, os});
        switch (os) {
            case linux: {
                return String.format("%s-%s/lib%s.so", new Object[]{jniResources, abi, libName});
            }
            case macos: {
                return String.format("%s/lib%s.dylib", jniResources, libName);
            }
            case windows: {
                if (arch != Arch.x86_64) break;
                return String.format("%s/%s.dll", jniResources, libName);
            }
        }
        throw new AssertionError("Unsupported OS-arch %s-%s", new Object[]{os, arch});
    }

    static enum Abi {
        none,
        gnu,
        musl;


        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static Abi getAbi(OS os) {
            if (os != OS.linux) {
                return none;
            }
            Path mapFiles = Paths.get("/proc/self/map_files", new String[0]);
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(mapFiles);){
                Iterator<Path> iterator = stream.iterator();
                while (iterator.hasNext()) {
                    Path path = iterator.next();
                    try {
                        String libName = path.toRealPath(new LinkOption[0]).toString().toLowerCase();
                        if (!libName.contains("musl")) continue;
                        Abi abi = musl;
                        return abi;
                    }
                    catch (IOException exception) {}
                }
                return gnu;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return gnu;
        }
    }

    static enum Arch {
        x86_64,
        aarch64;


        public static Arch getArch() {
            String osArch = System.getProperty("os.arch").toLowerCase();
            if (osArch.startsWith("x86_64") || osArch.startsWith("amd64") || osArch.startsWith("x64")) {
                return x86_64;
            }
            if (osArch.startsWith("aarch64")) {
                return aarch64;
            }
            throw new AssertionError(String.format("Unsupported OS arch %s", osArch), new Object[0]);
        }
    }

    static enum OS {
        windows,
        linux,
        macos;


        public static OS getOS() {
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.startsWith("win")) {
                return windows;
            }
            if (osName.startsWith("mac") || osName.startsWith("darwin")) {
                return macos;
            }
            if (osName.startsWith("linux")) {
                return linux;
            }
            throw new AssertionError(String.format("Unsupported OS %s", osName), new Object[0]);
        }
    }
}

