/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbeetle;

import com.tigerbeetle.AccountBatch;
import com.tigerbeetle.AsyncRequest;
import com.tigerbeetle.BlockingRequest;
import com.tigerbeetle.ConcurrencyExceededException;
import com.tigerbeetle.NativeClient;
import com.tigerbeetle.TransferBatch;
import java.util.concurrent.CompletableFuture;

public final class EchoClient
implements AutoCloseable {
    private final NativeClient nativeClient;

    public EchoClient(byte[] clusterID, String replicaAddresses, int concurrencyMax) {
        this.nativeClient = NativeClient.initEcho(clusterID, replicaAddresses, concurrencyMax);
    }

    public AccountBatch echo(AccountBatch batch) throws ConcurrencyExceededException {
        BlockingRequest<AccountBatch> request = BlockingRequest.echo(this.nativeClient, batch);
        request.beginRequest();
        return request.waitForResult();
    }

    public TransferBatch echo(TransferBatch batch) throws ConcurrencyExceededException {
        BlockingRequest<TransferBatch> request = BlockingRequest.echo(this.nativeClient, batch);
        request.beginRequest();
        return request.waitForResult();
    }

    public CompletableFuture<AccountBatch> echoAsync(AccountBatch batch) throws ConcurrencyExceededException {
        AsyncRequest<AccountBatch> request = AsyncRequest.echo(this.nativeClient, batch);
        request.beginRequest();
        return request.getFuture();
    }

    public CompletableFuture<TransferBatch> echoAsync(TransferBatch batch) throws ConcurrencyExceededException {
        AsyncRequest<TransferBatch> request = AsyncRequest.echo(this.nativeClient, batch);
        request.beginRequest();
        return request.getFuture();
    }

    @Override
    public void close() throws Exception {
        this.nativeClient.close();
    }
}

