/*
 * Decompiled with CFR 0.152.
 */
package com.tietoevry.quarkus.resteasy.problem.security;

import com.tietoevry.quarkus.resteasy.problem.ExceptionMapperBase;
import com.tietoevry.quarkus.resteasy.problem.HttpProblem;
import com.tietoevry.quarkus.resteasy.problem.security.HttpUnauthorizedUtils;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import java.lang.annotation.Annotation;
import javax.annotation.Priority;
import javax.enterprise.inject.spi.CDI;

@Priority(value=4999)
public final class AuthenticationFailedExceptionMapper
extends ExceptionMapperBase<AuthenticationFailedException> {
    volatile CurrentVertxRequest currentVertxRequest;

    @Override
    protected HttpProblem toProblem(AuthenticationFailedException exception) {
        return (HttpProblem)HttpUnauthorizedUtils.toProblem(this.currentVertxRequest().getCurrent(), (Exception)exception).await().indefinitely();
    }

    private CurrentVertxRequest currentVertxRequest() {
        if (this.currentVertxRequest == null) {
            this.currentVertxRequest = (CurrentVertxRequest)CDI.current().select(CurrentVertxRequest.class, new Annotation[0]).get();
        }
        return this.currentVertxRequest;
    }
}

