/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.tools.benchmark.metrics;

import com.thoughtworks.xstream.tools.benchmark.Metric;
import com.thoughtworks.xstream.tools.benchmark.Product;
import com.thoughtworks.xstream.tools.benchmark.Target;
import java.io.ByteArrayOutputStream;

public class CharacterCountMetric
implements Metric {
    private final char ch;

    public CharacterCountMetric(char ch) {
        this.ch = ch;
    }

    public double run(Product product, Target target) throws Exception {
        return this.run(product, target.target());
    }

    public double run(Product product, Object object) throws Exception {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        product.serialize(object, buffer);
        String s = buffer.toString();
        int counter = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != this.ch) continue;
            ++counter;
        }
        return counter;
    }

    public String toString() {
        return "Character count for '" + this.ch + "'";
    }

    public String unit() {
        return "characters";
    }

    public boolean biggerIsBetter() {
        return false;
    }
}

