/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2tdnego;

import com.teradata.tdgss.asn1.der.DER;
import com.teradata.tdgss.asn1.der.ListArray;
import com.teradata.tdgss.jgssp2tdnego.NegMechHashTable;

public class NegTokenInit {
    public static final int NEG_STATE_INVALID = 0;
    public static final int NEG_STATE_COMPLETED = 1;
    public static final int NEG_STATE_INCOMPLETE = 2;
    public static final int NEG_STATE_REJECT = 3;
    public static final int NEG_STATE_REQUEST_MIC = 4;
    public static final int NEG_STATE_INVALID_LAST = 5;
    private NegMechHashTable negMechHashTable;
    private int negState;
    private String authenticationID;
    private boolean isAuthenticationIDSet = false;
    private int isSSO;
    private boolean isIsSSOSet = false;
    private String userName;
    private boolean isUserNameSet = false;
    private String profileName;
    private boolean isProfileNameSet = false;
    static /* synthetic */ Class class$com$teradata$tdgss$asn1$der$DER;

    public NegMechHashTable getNegMechHashTable() {
        return this.negMechHashTable;
    }

    public void setNegMechHashTable(NegMechHashTable negMechHashTable) {
        this.negMechHashTable = negMechHashTable;
    }

    public int getNegState() {
        return this.negState;
    }

    public void setNegState(int n) {
        if (0 >= n || n >= 5) {
            throw new IllegalArgumentException("Invalid Negotiation State.");
        }
        this.negState = n;
    }

    public String getAuthenticationID() {
        return this.authenticationID;
    }

    public void setAuthenticationID(String string) {
        this.authenticationID = string;
        this.isAuthenticationIDSet = true;
    }

    public boolean getSSO() {
        return this.isSSO == 1;
    }

    public void setSSO(boolean bl) {
        this.isSSO = bl ? 1 : 0;
        this.isIsSSOSet = true;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        this.userName = string;
        this.isUserNameSet = true;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String string) {
        this.profileName = string;
        this.isProfileNameSet = true;
    }

    public boolean isAuthenticationIDSet() {
        return this.isAuthenticationIDSet;
    }

    public boolean isSSOSet() {
        return this.isIsSSOSet;
    }

    public boolean isUserNameSet() {
        return this.isUserNameSet;
    }

    public boolean isProfileNameSet() {
        return this.isProfileNameSet;
    }

    public DER getDERObject() {
        DER dER = new DER(0, new ListArray(class$com$teradata$tdgss$asn1$der$DER == null ? (class$com$teradata$tdgss$asn1$der$DER = NegTokenInit.class$("com.teradata.tdgss.asn1.der.DER")) : class$com$teradata$tdgss$asn1$der$DER));
        DER dER2 = this.negMechHashTable.getDERObject();
        dER.add(dER2);
        dER.add(new DER(1, (long)this.negState));
        if (this.isAuthenticationIDSet()) {
            dER.add(new DER(2, this.authenticationID));
        }
        if (this.isSSOSet()) {
            dER.add(new DER(3, (long)this.isSSO));
        }
        if (this.isUserNameSet()) {
            dER.add(new DER(4, this.userName));
        }
        if (this.isProfileNameSet()) {
            dER.add(new DER(5, this.profileName));
        }
        return dER;
    }

    public void parseDERObject(DER dER) {
        DER dER2;
        DER dER3;
        DER dER4;
        if (dER.getTagNumber() != 0) {
            throw new IllegalArgumentException("Negotiation Init token's tag is not valid");
        }
        DER dER5 = dER.getChildrenWithTag(0);
        if (dER5 == null) {
            throw new IllegalArgumentException("Tag NEGTOKENINIT_TAG_NEGMECHLIST is not found.");
        }
        this.negMechHashTable = new NegMechHashTable();
        this.negMechHashTable.parseDERObject(dER5);
        DER dER6 = dER.getChildrenWithTag(1);
        if (dER6 == null) {
            throw new IllegalArgumentException("Tag NEGTOKENINIT_TAG_NEGSTATE is not found.");
        }
        this.negState = (int)dER6.getValueAsInt();
        DER dER7 = dER.getChildrenWithTag(2);
        if (dER7 != null) {
            this.setAuthenticationID(dER7.getValueAsUTF8String());
        }
        if ((dER4 = dER.getChildrenWithTag(3)) != null) {
            if (dER4.getValueAsInt() == 0L) {
                this.setSSO(false);
            } else {
                this.setSSO(true);
            }
        }
        if ((dER3 = dER.getChildrenWithTag(4)) != null) {
            this.setUserName(dER3.getValueAsUTF8String());
        }
        if ((dER2 = dER.getChildrenWithTag(5)) != null) {
            this.setProfileName(dER2.getValueAsUTF8String());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

