/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdk6;

import com.teradata.jdbc.TeraSQLXML;
import com.teradata.jdbc.encode.Decoder;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.ifsupport.ClobCharacterStream;
import com.teradata.jdbc.jdbc_4.ifsupport.ClobReader;
import com.teradata.jdbc.jdbc_4.ifsupport.LobBuffer;
import com.teradata.jdbc.jdbc_4.ifsupport.LobStream;
import com.teradata.jdbc.jdbc_4.ifsupport.XMLContentHandler;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.sql.SQLXML;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class JDK6_SQL_SQLXML
extends TeraSQLXML
implements SQLXML,
ErrorListener {
    private static final int READABLE = 1;
    private static final int WRITABLE = 2;
    private static final int FREE = 4;
    private TDSession m_session;
    private long m_nLength;
    private byte[] m_abyLocator = null;
    private int m_nState;
    private short m_nSQLXMLType;
    private Object m_oValue;
    private LobStream m_lobStream = null;
    private LobBuffer m_slobBuffer;

    public JDK6_SQL_SQLXML(TDSession tDSession) {
        this.m_session = tDSession;
        this.m_nState = 2;
    }

    public JDK6_SQL_SQLXML(TDSession tDSession, short s, long l, byte[] byArray) {
        this.m_session = tDSession;
        this.m_nSQLXMLType = s;
        this.m_nLength = l;
        this.m_abyLocator = byArray;
        this.m_nState = 1;
    }

    @Override
    public synchronized void free() throws SQLException {
        this.m_nState = 4;
        if (this.m_lobStream != null) {
            try {
                this.m_lobStream.close();
            }
            catch (IOException iOException) {
                throw JDK6_SQL_SQLXML.createNewException(iOException, "TJ767");
            }
            finally {
                this.m_lobStream = null;
            }
        }
        this.m_abyLocator = null;
        this.m_session = null;
        this.m_nLength = 0L;
        this.m_oValue = null;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.verifyAndUpdateReadState();
        return this.internalGetBinaryStream();
    }

    @Override
    public LobStream internalGetBinaryStream() throws SQLException {
        this.m_lobStream = new LobStream(this.m_session, this.m_abyLocator, this.getSlobData(), this.m_nSQLXMLType, this.m_nLength);
        return this.m_lobStream;
    }

    @Override
    public byte[] getBytes() throws SQLException {
        byte[] byArray = new byte[(int)this.m_nLength];
        try {
            int n = 0;
            int n2 = 0;
            LobStream lobStream = this.internalGetBinaryStream();
            while (byArray.length - n2 > 0 && n != -1) {
                n2 += (n = ((InputStream)lobStream).read(byArray, n2, byArray.length - n2)) == -1 ? 0 : n;
            }
        }
        catch (IOException iOException) {
            throw JDK6_SQL_SQLXML.createNewException(iOException, "TJ765");
        }
        return byArray;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.verifyAndUpdateReadState();
        return this.internalGetCharacterStream();
    }

    @Override
    public Reader internalGetCharacterStream() throws SQLException {
        ClobReader clobReader = new ClobReader(this.m_session, this.m_abyLocator, this.getSlobData(), this.m_nSQLXMLType, this.m_nLength);
        this.m_lobStream = clobReader.getClobCharacterSteam();
        return clobReader;
    }

    @Override
    public OutputStream setBinaryStream() throws SQLException {
        this.verifyAndUpdateWriteState();
        return this.internalSetBinaryStream();
    }

    private OutputStream internalSetBinaryStream() throws SQLException {
        this.m_nSQLXMLType = (short)857;
        this.m_nLength = 2097088000L;
        this.m_oValue = new ByteArrayOutputStream();
        return (ByteArrayOutputStream)this.m_oValue;
    }

    @Override
    public String getString() throws SQLException {
        this.verifyAndUpdateReadState();
        return this.internalGetString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String internalGetString() throws SQLException {
        String string;
        ClobCharacterStream clobCharacterStream = new ClobCharacterStream(this.m_session, this.m_abyLocator, this.getSlobData(), this.m_nSQLXMLType, this.m_nLength);
        try {
            char[] cArray = new char[(int)this.m_nLength];
            clobCharacterStream.read(cArray, 0, cArray.length);
            string = new String(cArray);
        }
        catch (Throwable throwable) {
            try {
                clobCharacterStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw JDK6_SQL_SQLXML.createNewException(iOException, "TJ765");
            }
        }
        clobCharacterStream.close();
        return string;
    }

    @Override
    public Writer setCharacterStream() throws SQLException {
        this.verifyAndUpdateWriteState();
        this.m_nSQLXMLType = (short)857;
        this.m_nLength = 2097088000L;
        this.m_oValue = new StringWriter();
        return (StringWriter)this.m_oValue;
    }

    @Override
    public synchronized void setString(String string) throws SQLException {
        this.verifyAndUpdateWriteState();
        if (string == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ777");
        }
        this.m_oValue = new StringReader(string);
        this.m_nSQLXMLType = (short)857;
        this.m_nLength = string.length();
    }

    private synchronized void verifyAndUpdateWriteState() throws SQLException {
        if (this.hasBeenFreed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ760");
        }
        if (!this.isWritable()) {
            throw ErrorFactory.makeDriverJDBCException("TJ768");
        }
        this.removeState(2);
    }

    private synchronized void verifyAndUpdateReadState() throws SQLException {
        if (this.hasBeenFreed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ760");
        }
        if (!this.isReadable()) {
            throw ErrorFactory.makeDriverJDBCException("TJ769");
        }
        this.removeState(1);
    }

    private void removeState(int n) {
        this.m_nState &= ~n;
    }

    private boolean hasBeenFreed() {
        return (this.m_nState & 4) != 0;
    }

    private boolean isReadable() {
        return (this.m_nState & 1) != 0;
    }

    private boolean isWritable() {
        return (this.m_nState & 2) != 0;
    }

    @Override
    public void storeXMLContent(Object object) {
        this.m_oValue = object;
    }

    @Override
    public int getSQLXMLType() {
        return this.m_nSQLXMLType;
    }

    @Override
    public byte[] getLocator() {
        return this.m_abyLocator;
    }

    @Override
    public long getLength() {
        return this.m_nLength;
    }

    private static SQLException createNewException(Exception exception, String string) {
        SQLException sQLException = ErrorFactory.makeDriverJDBCException(string);
        sQLException.initCause(exception);
        return sQLException;
    }

    @Override
    public <T extends Source> T getSource(Class<T> clazz) throws SQLException {
        this.verifyAndUpdateReadState();
        if (clazz == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ778");
        }
        if (DOMSource.class.isAssignableFrom(clazz)) {
            InputSource inputSource = this.getSQLXMLType() == 864 ? new InputSource(this.internalGetBinaryStream()) : new InputSource(this.internalGetCharacterStream());
            Document document = null;
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                if (!this.m_session.getURLParameters().getXXEProcessing()) {
                    if (this.m_session.getLog().isDebugEnabled()) {
                        this.m_session.getLog().debug("Turn off XML External Entity (XXE) references and disallow Document Type Definitions (DTDs)");
                    }
                    documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                    documentBuilderFactory.setXIncludeAware(false);
                    documentBuilderFactory.setExpandEntityReferences(false);
                }
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                documentBuilder.setErrorHandler(new ParseErrorHandler());
                document = documentBuilder.parse(inputSource);
            }
            catch (IOException iOException) {
                throw JDK6_SQL_SQLXML.createNewException(iOException, "TJ766");
            }
            catch (SAXException sAXException) {
                throw JDK6_SQL_SQLXML.createNewException(sAXException, "TJ766");
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw JDK6_SQL_SQLXML.createNewException(parserConfigurationException, "TJ766");
            }
            return (T)((Source)clazz.cast(new DOMSource(document)));
        }
        if (SAXSource.class.isAssignableFrom(clazz)) {
            InputSource inputSource = new InputSource(this.internalGetBinaryStream());
            return (T)((Source)clazz.cast(new SAXSource(inputSource)));
        }
        if (StAXSource.class.isAssignableFrom(clazz)) {
            XMLStreamReader xMLStreamReader;
            XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
            try {
                xMLStreamReader = this.getSQLXMLType() == 864 ? xMLInputFactory.createXMLStreamReader(this.internalGetBinaryStream()) : xMLInputFactory.createXMLStreamReader(this.internalGetCharacterStream());
            }
            catch (XMLStreamException xMLStreamException) {
                throw JDK6_SQL_SQLXML.createNewException(xMLStreamException, "TJ766");
            }
            return (T)((Source)clazz.cast(new StAXSource(xMLStreamReader)));
        }
        if (StreamSource.class.isAssignableFrom(clazz)) {
            return (T)((Source)clazz.cast(new StreamSource(this.internalGetBinaryStream())));
        }
        throw ErrorFactory.makeDriverJDBCException("TJ770", clazz.getName());
    }

    @Override
    public <T extends Result> T setResult(Class<T> clazz) throws SQLException {
        this.verifyAndUpdateWriteState();
        this.m_nSQLXMLType = (short)857;
        this.m_nLength = 2097088000L;
        if (clazz == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ779");
        }
        Result result = null;
        if (DOMResult.class.isAssignableFrom(clazz)) {
            result = (Result)clazz.cast(new DOMResult());
            this.m_oValue = result;
        } else if (SAXResult.class.isAssignableFrom(clazz)) {
            try {
                result = (Result)clazz.cast(new SAXResult());
                XMLReader xMLReader = XMLReaderFactory.createXMLReader();
                xMLReader.setContentHandler(new XMLContentHandler(this, xMLReader));
                ((SAXResult)result).setHandler(xMLReader.getContentHandler());
                this.m_oValue = result;
            }
            catch (SAXException sAXException) {
                throw JDK6_SQL_SQLXML.createNewException(sAXException, "TJ766");
            }
        } else if (StAXResult.class.isAssignableFrom(clazz)) {
            XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
            try {
                OutputStream outputStream = this.internalSetBinaryStream();
                result = (Result)clazz.cast(new StAXResult(xMLOutputFactory.createXMLStreamWriter(outputStream, "UTF8")));
            }
            catch (XMLStreamException xMLStreamException) {
                throw JDK6_SQL_SQLXML.createNewException(xMLStreamException, "TJ766");
            }
        } else if (StreamResult.class.isAssignableFrom(clazz)) {
            this.m_oValue = new ByteArrayOutputStream();
            result = (Result)clazz.cast(new StreamResult((OutputStream)this.m_oValue));
        } else {
            throw ErrorFactory.makeDriverJDBCException("TJ771", clazz.getName());
        }
        return (T)result;
    }

    @Override
    public Object composeBindValue(int n) throws SQLException {
        if (this.hasBeenFreed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ760");
        }
        if (this.m_oValue == null) {
            if (this.m_abyLocator != null) {
                this.m_nSQLXMLType = (short)861;
                return this.m_abyLocator;
            }
            throw ErrorFactory.makeDriverJDBCException("TJ773", n);
        }
        if (this.m_oValue instanceof DOMResult) {
            DOMSource dOMSource = new DOMSource(((DOMResult)this.m_oValue).getNode());
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            try {
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setErrorListener(this);
                transformer.transform(dOMSource, streamResult);
            }
            catch (TransformerException transformerException) {
                SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ775", n);
                sQLException.initCause(transformerException);
                throw sQLException;
            }
            this.m_oValue = new StringReader(stringWriter.toString());
        } else {
            if (this.m_oValue instanceof SAXResult || this.m_oValue instanceof StAXResult || this.m_oValue instanceof StreamResult) {
                throw ErrorFactory.makeDriverJDBCException("TJ774", String.valueOf(n), this.m_oValue.getClass().getName());
            }
            if (this.m_oValue instanceof StringWriter) {
                this.m_oValue = new StringReader(((StringWriter)this.m_oValue).toString());
            } else if (this.m_oValue instanceof ByteArrayOutputStream) {
                this.m_oValue = new StringReader(Decoder.getUTF8DecodedString(((ByteArrayOutputStream)this.m_oValue).toByteArray()));
            }
        }
        if (this.m_oValue instanceof Reader) {
            return this.m_oValue;
        }
        throw ErrorFactory.makeDriverJDBCException("TJ774", String.valueOf(n), this.m_oValue.getClass().getName());
    }

    @Override
    public void setSlobData(LobBuffer lobBuffer) {
        this.m_slobBuffer = lobBuffer;
    }

    private LobBuffer getSlobData() {
        if (this.m_slobBuffer != null) {
            this.m_slobBuffer.resetBuffer();
        }
        return this.m_slobBuffer;
    }

    @Override
    public void error(TransformerException transformerException) throws TransformerException {
        throw transformerException;
    }

    @Override
    public void fatalError(TransformerException transformerException) throws TransformerException {
        throw transformerException;
    }

    @Override
    public void warning(TransformerException transformerException) throws TransformerException {
    }

    private static class ParseErrorHandler
    implements ErrorHandler {
        private ParseErrorHandler() {
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
        }
    }
}

