/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws.entity;

import com.taosdata.jdbc.ws.entity.Action;
import com.taosdata.jdbc.ws.entity.Code;
import com.taosdata.jdbc.ws.entity.Response;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.nio.charset.StandardCharsets;

public class FetchBlockNewResp
extends Response {
    private ByteBuf buffer;
    private boolean isCompleted;
    private long time;
    private int code;
    private String message;
    private short version;

    public void setCompleted(boolean completed) {
        this.isCompleted = completed;
    }

    public FetchBlockNewResp(ByteBuf buffer) {
        this.setAction(Action.FETCH_BLOCK_NEW.getAction());
        this.buffer = buffer;
    }

    public void init() {
        this.buffer.readLongLE();
        this.version = this.buffer.readShortLE();
        this.time = this.buffer.readLongLE();
        this.setReqId(this.buffer.readLongLE());
        this.code = this.buffer.readIntLE();
        int messageLen = this.buffer.readIntLE();
        byte[] msgBytes = new byte[messageLen];
        this.buffer.readBytes(msgBytes);
        this.message = new String(msgBytes, StandardCharsets.UTF_8);
        this.buffer.readLongLE();
        boolean bl = this.isCompleted = this.buffer.readByte() != 0;
        if (this.isCompleted || this.code != Code.SUCCESS.getCode()) {
            ReferenceCountUtil.safeRelease((Object)this.buffer);
        }
    }

    public ByteBuf getBuffer() {
        return this.buffer;
    }

    public void setBuffer(ByteBuf buffer) {
        this.buffer = buffer;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public long getTime() {
        return this.time;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public short getVersion() {
        return this.version;
    }
}

