/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws;

import com.taosdata.jdbc.AbstractDriver;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.rs.ConnectionParam;
import com.taosdata.jdbc.utils.StringUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

public class WebSocketDriver
extends AbstractDriver {
    public static final String URL_PREFIX = "jdbc:TAOS-WS://";

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (url == null || url.trim().isEmpty() || url.trim().replaceAll("\\s", "").isEmpty()) {
            throw TSDBError.createSQLException(8978);
        }
        if (!this.acceptsURL(url)) {
            return null;
        }
        Properties props = StringUtils.parseUrl(url, info, false);
        ConnectionParam param = ConnectionParam.getParamWs(props);
        return this.getWSConnection(url, param, props);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw TSDBError.createSQLException(8978);
        }
        return url.trim().length() > 0 && url.startsWith(URL_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (info == null) {
            info = new Properties();
        }
        if (this.acceptsURL(url)) {
            info = StringUtils.parseUrl(url, info, false);
        }
        return this.getPropertyInfo(info);
    }

    @Override
    public int getMajorVersion() {
        return 3;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        try {
            DriverManager.registerDriver(new WebSocketDriver());
        }
        catch (SQLException e) {
            throw TSDBError.createRuntimeException(8978, e);
        }
    }
}

