/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.utils;

import com.taosdata.jdbc.TSDBError;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class StringUtils {
    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNumeric(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Properties parseHostPort(String hostPortDb, boolean isNative) throws SQLException {
        Properties properties = new Properties();
        String host = hostPortDb;
        String port = null;
        if (hostPortDb.startsWith("[")) {
            int endBracket = hostPortDb.indexOf(93);
            if (endBracket == -1) throw TSDBError.createSQLException(8963, "Invalid IPv6 address: " + hostPortDb);
            host = isNative ? hostPortDb.substring(1, endBracket) : hostPortDb.substring(0, endBracket + 1);
            if (endBracket + 1 < hostPortDb.length() && hostPortDb.charAt(endBracket + 1) == ':') {
                port = hostPortDb.substring(endBracket + 2);
            }
        } else {
            int lastColon = hostPortDb.lastIndexOf(58);
            if (lastColon != -1) {
                host = hostPortDb.substring(0, lastColon);
                port = hostPortDb.substring(lastColon + 1);
            }
        }
        if (host.contains("%")) {
            host = host.replace("%", "%25");
        }
        if (!host.trim().isEmpty()) {
            properties.setProperty("host", host);
        }
        if (port == null || port.trim().isEmpty()) return properties;
        properties.setProperty("port", port);
        return properties;
    }

    public static Properties parseUrl(String url, Properties defaults, boolean isNative) throws SQLException {
        Properties urlProps;
        Properties properties = urlProps = defaults != null ? defaults : new Properties();
        if (StringUtils.isEmpty(url)) {
            return urlProps;
        }
        int paramStart = url.indexOf("?");
        if (paramStart != -1) {
            String paramString = url.substring(paramStart + 1);
            url = url.substring(0, paramStart);
            StringTokenizer queryParams = new StringTokenizer(paramString, "&");
            while (queryParams.hasMoreElements()) {
                String value;
                String pair = queryParams.nextToken();
                int eqIdx = pair.indexOf("=");
                if (eqIdx == -1) continue;
                String key = pair.substring(0, eqIdx);
                String string = value = eqIdx + 1 < pair.length() ? pair.substring(eqIdx + 1) : "";
                if (key.isEmpty() || value.isEmpty()) continue;
                urlProps.setProperty(key, value);
            }
        }
        int slashesStart = url.indexOf("//");
        String dbProductName = url.substring(0, slashesStart);
        dbProductName = dbProductName.substring(dbProductName.indexOf(":") + 1);
        dbProductName = dbProductName.substring(0, dbProductName.indexOf(":"));
        urlProps.setProperty("productName", dbProductName);
        String hostPortDb = url.substring(slashesStart + 2);
        int dbStart = hostPortDb.indexOf("/");
        if (dbStart != -1) {
            if (dbStart + 1 < hostPortDb.length()) {
                urlProps.setProperty("dbname", hostPortDb.substring(dbStart + 1).toLowerCase());
            }
            hostPortDb = hostPortDb.substring(0, dbStart);
        }
        Properties hostPortProps = StringUtils.parseHostPort(hostPortDb, isNative);
        urlProps.putAll((Map<?, ?>)hostPortProps);
        return urlProps;
    }

    public static byte[] hexToBytes(String hex) {
        int byteLen = hex.length() / 2;
        byte[] bytes = new byte[byteLen];
        for (int i = 0; i < hex.length() / 2; ++i) {
            byte b;
            int i2 = 2 * i;
            if (i2 + 1 > hex.length()) {
                throw new IllegalArgumentException("Hex string has odd length");
            }
            int nib1 = StringUtils.hexToInt(hex.charAt(i2));
            int nib0 = StringUtils.hexToInt(hex.charAt(i2 + 1));
            bytes[i] = b = (byte)((nib1 << 4) + (byte)nib0);
        }
        return bytes;
    }

    private static int hexToInt(char hex) {
        int nib = Character.digit(hex, 16);
        if (nib < 0) {
            throw new IllegalArgumentException("Invalid hex digit: '" + hex + "'");
        }
        return nib;
    }

    public static String bytesToHex(byte[] bytes) {
        return StringUtils.toHex(bytes);
    }

    public static String toHex(byte[] bytes) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            buf.append(StringUtils.toHexDigit(b >> 4 & 0xF));
            buf.append(StringUtils.toHexDigit(b & 0xF));
        }
        return buf.toString();
    }

    private static char toHexDigit(int n) {
        if (n < 0 || n > 15) {
            throw new IllegalArgumentException("Nibble value out of range: " + n);
        }
        if (n <= 9) {
            return (char)(48 + n);
        }
        return (char)(65 + (n - 10));
    }

    public static String getBasicUrl(String url) {
        if (url == null || url.trim().length() == 0) {
            return "";
        }
        int firstIndex = url.indexOf("?");
        if (firstIndex > 0) {
            return url.substring(0, firstIndex);
        }
        return url;
    }
}

