/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.tmq;

import com.taosdata.jdbc.enums.TmqMessageType;
import com.taosdata.jdbc.ws.tmq.meta.Meta;

public class ConsumerRecord<V> {
    private final String topic;
    private final String dbName;
    private final int vGroupId;
    private final long offset;
    private final TmqMessageType messageType;
    private final Meta meta;
    private final V value;

    private ConsumerRecord(Builder<V> builder) {
        this.topic = ((Builder)builder).topic;
        this.dbName = ((Builder)builder).dbName;
        this.vGroupId = ((Builder)builder).vGroupId;
        this.offset = ((Builder)builder).offset;
        this.messageType = ((Builder)builder).messageType;
        this.meta = ((Builder)builder).meta;
        this.value = ((Builder)builder).value;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getDbName() {
        return this.dbName;
    }

    public int getVGroupId() {
        return this.vGroupId;
    }

    public V value() {
        return this.value;
    }

    public long getOffset() {
        return this.offset;
    }

    public TmqMessageType getMessageType() {
        return this.messageType;
    }

    public Meta getMeta() {
        return this.meta;
    }

    public static class Builder<V> {
        private String topic;
        private String dbName;
        private Integer vGroupId;
        private long offset = 0L;
        private TmqMessageType messageType;
        private Meta meta;
        private V value;

        public Builder<V> topic(String topic) {
            this.topic = topic;
            return this;
        }

        public Builder<V> dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public Builder<V> vGroupId(int vGroupId) {
            this.vGroupId = vGroupId;
            return this;
        }

        public Builder<V> offset(long offset) {
            this.offset = offset;
            return this;
        }

        public Builder<V> messageType(TmqMessageType messageType) {
            this.messageType = messageType;
            return this;
        }

        public Builder<V> meta(Meta meta) {
            this.meta = meta;
            return this;
        }

        public Builder<V> value(V value) {
            this.value = value;
            return this;
        }

        public ConsumerRecord<V> build() {
            if (this.messageType == TmqMessageType.TMQ_RES_DATA) {
                if (this.topic == null || this.dbName == null || this.vGroupId == null || this.value == null) {
                    throw new IllegalStateException("for data type, Topic, dbName, vGroupId and value are required.");
                }
            } else if (this.messageType == TmqMessageType.TMQ_RES_TABLE_META) {
                if (this.topic == null || this.dbName == null || this.vGroupId == null || this.meta == null) {
                    throw new IllegalStateException("for meta type, Topic, dbName, vGroupId, meta are required.");
                }
            } else {
                throw new IllegalStateException("Unknown messageType: " + (Object)((Object)this.messageType));
            }
            return new ConsumerRecord(this);
        }
    }
}

