/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.AbstractStatement;
import com.taosdata.jdbc.TSDBConnection;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.TSDBResultSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class TSDBStatement
extends AbstractStatement {
    private boolean isClosed;
    private TSDBConnection connection;
    private TSDBResultSet resultSet;

    TSDBStatement(TSDBConnection connection) {
        this.connection = connection;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        long pSql = this.connection.getConnector().executeQuery(sql);
        if (this.connection.getConnector().isUpdateQuery(pSql)) {
            this.connection.getConnector().freeResultSet(pSql);
            throw TSDBError.createSQLException(8967);
        }
        TSDBResultSet res = new TSDBResultSet(this, this.connection.getConnector(), pSql);
        int timestampPrecision = this.connection.getConnector().getResultTimePrecision(pSql);
        res.setTimestampPrecision(timestampPrecision);
        res.setBatchFetch(this.connection.getBatchFetch());
        return res;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        long pSql = this.connection.getConnector().executeQuery(sql);
        if (!this.connection.getConnector().isUpdateQuery(pSql)) {
            this.connection.getConnector().freeResultSet(pSql);
            throw TSDBError.createSQLException(8968);
        }
        int affectedRows = this.connection.getConnector().getAffectedRows(pSql);
        this.connection.getConnector().freeResultSet(pSql);
        return affectedRows;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (this.resultSet != null && !this.resultSet.isClosed()) {
            this.resultSet.close();
        }
        this.isClosed = true;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        long pSql = this.connection.getConnector().executeQuery(sql);
        if (this.connection.getConnector().isUpdateQuery(pSql)) {
            this.affectedRows = this.connection.getConnector().getAffectedRows(pSql);
            this.connection.getConnector().freeResultSet(pSql);
            return false;
        }
        this.resultSet = new TSDBResultSet(this, this.connection.getConnector(), pSql);
        this.resultSet.setBatchFetch(this.connection.getBatchFetch());
        return true;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return this.resultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return this.affectedRows;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        if (this.connection.getConnector() == null) {
            throw TSDBError.createSQLException(9044);
        }
        return this.connection;
    }

    public void setConnection(TSDBConnection connection) {
        this.connection = connection;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }
}

