/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.spring;

import com.synerset.unitility.spring.serialization.PhysicalQuantityWebMvcConverter;
import com.synerset.unitility.unitsystem.util.PhysicalQuantityParsingFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.format.FormatterRegistry;
import org.springframework.lang.NonNull;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@AutoConfiguration
class PhysicalQuantityWebMvcConfiguration
implements WebMvcConfigurer {
    private final PhysicalQuantityParsingFactory parsingFactory;

    PhysicalQuantityWebMvcConfiguration(@Qualifier(value="defaultParsingFactory") PhysicalQuantityParsingFactory parsingFactory) {
        this.parsingFactory = parsingFactory;
    }

    public void addFormatters(@NonNull FormatterRegistry registry) {
        this.parsingFactory.findAllRegisteredClasses().forEach(quantityClass -> registry.addConverter(String.class, quantityClass, new PhysicalQuantityWebMvcConverter(quantityClass, this.parsingFactory)));
    }
}

