/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.jackson.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.synerset.unitility.unitsystem.PhysicalQuantity;
import com.synerset.unitility.unitsystem.Unit;
import java.io.IOException;

public class PhysicalQuantitySerializer
extends StdSerializer<PhysicalQuantity<Unit>> {
    public PhysicalQuantitySerializer(JavaType type) {
        super(type);
    }

    public void serialize(PhysicalQuantity<Unit> quantity, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeNumberField("value", quantity.getValue());
        if (quantity.getUnitSymbol() != null && !quantity.getUnitSymbol().isBlank()) {
            jsonGenerator.writeStringField("unit", quantity.getUnitSymbol());
        }
        jsonGenerator.writeEndObject();
    }
}

