/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.jackson.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.synerset.unitility.unitsystem.common.Angle;
import com.synerset.unitility.unitsystem.common.Distance;
import com.synerset.unitility.unitsystem.common.DistanceUnit;
import com.synerset.unitility.unitsystem.common.DistanceUnits;
import com.synerset.unitility.unitsystem.geographic.GeoCoordinate;
import com.synerset.unitility.unitsystem.geographic.GeoDistance;
import com.synerset.unitility.unitsystem.util.PhysicalQuantityParsingFactory;
import java.io.IOException;

public class GeoDistanceDeserializer
extends JsonDeserializer<GeoDistance> {
    protected final PhysicalQuantityParsingFactory parsingFactory;

    public GeoDistanceDeserializer(PhysicalQuantityParsingFactory parsingFactory) {
        this.parsingFactory = parsingFactory;
    }

    public GeoDistance deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        JsonNode startCoordinateNode = node.get("startCoordinate");
        if (startCoordinateNode == null) {
            throw new IOException("Deserialization failure. Missing field: startCoordinate");
        }
        GeoCoordinate startCoordinate = (GeoCoordinate)startCoordinateNode.traverse(parser.getCodec()).readValueAs(GeoCoordinate.class);
        if (startCoordinate == null) {
            throw new IOException("Deserialization failure. Could not extract: startCoordinate");
        }
        JsonNode targetCoordinateNode = node.get("targetCoordinate");
        GeoCoordinate targetCoordinate = null;
        if (targetCoordinateNode != null) {
            targetCoordinate = (GeoCoordinate)targetCoordinateNode.traverse(parser.getCodec()).readValueAs(GeoCoordinate.class);
        }
        JsonNode unitTypeNode = node.get("unit");
        if (targetCoordinate != null && unitTypeNode != null) {
            DistanceUnit distanceUnit = DistanceUnits.fromSymbol((String)unitTypeNode.asText());
            return GeoDistance.of((GeoCoordinate)startCoordinate, (GeoCoordinate)targetCoordinate, (DistanceUnit)distanceUnit);
        }
        if (targetCoordinate != null) {
            return GeoDistance.ofKilometers((GeoCoordinate)startCoordinate, (GeoCoordinate)targetCoordinate);
        }
        Angle trueBearing = (Angle)node.get("trueBearing").traverse(parser.getCodec()).readValueAs(Angle.class);
        Distance distance = (Distance)node.get("distance").traverse(parser.getCodec()).readValueAs(Distance.class);
        return GeoDistance.of((GeoCoordinate)startCoordinate, (Angle)trueBearing, (Distance)distance);
    }
}

