/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.util;

import com.synerset.unitility.unitsystem.PhysicalQuantity;
import com.synerset.unitility.unitsystem.Unit;
import com.synerset.unitility.unitsystem.common.AngleUnits;
import com.synerset.unitility.unitsystem.exceptions.UnitSystemClassNotSupportedException;
import com.synerset.unitility.unitsystem.exceptions.UnitSystemParseException;
import com.synerset.unitility.unitsystem.geographic.DMSValidator;
import com.synerset.unitility.unitsystem.geographic.Latitude;
import com.synerset.unitility.unitsystem.geographic.Longitude;
import com.synerset.unitility.unitsystem.util.ParsingHelpers;
import com.synerset.unitility.unitsystem.util.PhysicalQuantityParsingFactory;
import com.synerset.unitility.unitsystem.util.StringTransformer;
import java.util.HashSet;
import java.util.Set;

public abstract class PhysicalQuantityAbstractParsingFactory
implements PhysicalQuantityParsingFactory {
    @Override
    public <U extends Unit, Q extends PhysicalQuantity<U>> Q parseValueAndSymbol(Class<Q> targetClass, double value, String symbolAsString) {
        this.validateIfClassIsRegistered(targetClass);
        return (Q)((PhysicalQuantity)targetClass.cast(this.getClassRegistry().get(targetClass).apply(value, symbolAsString)));
    }

    @Override
    public <U extends Unit, Q extends PhysicalQuantity<U>> Q parse(Class<Q> targetClass, String quantityAsString) {
        String preparedInput = StringTransformer.of(quantityAsString).trimLowerAndClean().replaceCommaForDot().dropParentheses().toString();
        Pair extractedPair = this.isGeoQuantity(targetClass) && DMSValidator.isValidDMSFormat(preparedInput) ? this.extractValueAndSymbolFromDMSFormat(targetClass, preparedInput) : this.extractValueAndSymbol(preparedInput);
        return this.parseValueAndSymbol(targetClass, extractedPair.value, extractedPair.symbol);
    }

    @Override
    public boolean containsClass(Class<?> targetClass) {
        return this.getClassRegistry().containsKey(targetClass);
    }

    @Override
    public <U extends Unit, Q extends PhysicalQuantity<U>> Set<Class<Q>> findAllRegisteredClasses() {
        HashSet quantityClasses = new HashSet();
        this.getClassRegistry().keySet().forEach(quantityClass -> quantityClasses.add((Class)quantityClass));
        return quantityClasses;
    }

    private <U extends Unit, Q extends PhysicalQuantity<U>> void validateIfClassIsRegistered(Class<Q> targetClass) {
        if (!this.containsClass(targetClass)) {
            throw new UnitSystemClassNotSupportedException("Class not found in the registry: " + targetClass.getSimpleName());
        }
    }

    private boolean isGeoQuantity(Class<?> targetClass) {
        return Latitude.class.isAssignableFrom(targetClass) || Longitude.class.isAssignableFrom(targetClass);
    }

    private Pair extractValueAndSymbol(String preparedInput) {
        int indexOfLastDigit = 0;
        for (char letter : preparedInput.toCharArray()) {
            if (!Character.isDigit(letter) && letter != '.' && letter != '-' && letter != 'e') break;
            ++indexOfLastDigit;
        }
        String valuePart = preparedInput.substring(0, indexOfLastDigit);
        String symbolPart = preparedInput.substring(indexOfLastDigit);
        double value = ParsingHelpers.parseToDouble(valuePart);
        return new Pair(value, symbolPart);
    }

    private Pair extractValueAndSymbolFromDMSFormat(Class<?> targetClass, String partiallyPreparedInput) {
        String preparedInput = StringTransformer.of(partiallyPreparedInput).unifyDMSNotationSymbols().toString();
        if (Latitude.class.isAssignableFrom(targetClass) && (preparedInput.contains("e") || preparedInput.contains("w"))) {
            throw new UnitSystemParseException("Invalid latitude direction. Expected: N or S. Input: " + preparedInput);
        }
        if (Longitude.class.isAssignableFrom(targetClass) && (preparedInput.contains("n") || preparedInput.contains("s"))) {
            throw new UnitSystemParseException("Invalid longitude direction. Expected: W or E. Input: " + preparedInput);
        }
        double valueInDegrees = ParsingHelpers.extractDegreesFromDMSFormat(preparedInput);
        return new Pair(valueInDegrees, AngleUnits.DEGREES.getSymbol());
    }

    record Pair(Double value, String symbol) {
    }
}

