/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.util;

import com.synerset.unitility.unitsystem.exceptions.UnitSystemArgumentException;
import com.synerset.unitility.unitsystem.exceptions.UnitSystemParseException;
import com.synerset.unitility.unitsystem.geographic.HaversineEquations;

public class ParsingHelpers {
    private ParsingHelpers() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean containsNonDigitChars(String inputString) {
        String preparedString = inputString.toLowerCase().replace("-", "").replace("e", "");
        for (char nextChar : preparedString.toCharArray()) {
            if (!Character.isAlphabetic(nextChar)) continue;
            return true;
        }
        return false;
    }

    public static double parseToDouble(String doubleAsString, String addedMessage) {
        try {
            return Double.parseDouble(doubleAsString);
        }
        catch (NumberFormatException ex) {
            throw new UnitSystemParseException(addedMessage + "Invalid input, could not parse to double, input = " + doubleAsString);
        }
    }

    public static double parseToDouble(String doubleAsString) {
        return ParsingHelpers.parseToDouble(doubleAsString, "");
    }

    public static double extractDegreesFromDMSFormat(String dmsFormat) {
        if (dmsFormat == null || dmsFormat.isBlank()) {
            throw new UnitSystemArgumentException("Geo parser: Invalid input. Argument cannot be null or blank.");
        }
        String[] parts = dmsFormat.split("[o'\"nsew]");
        if (parts.length == 0) {
            throw new UnitSystemArgumentException("Geo DMS parser: Input string could not be parsed: input = " + dmsFormat);
        }
        double degrees = ParsingHelpers.parseToDouble(parts[0]);
        double minutes = 0.0;
        if (parts.length > 1) {
            minutes = ParsingHelpers.parseToDouble(parts[1]);
        }
        double seconds = 0.0;
        if (parts.length > 2) {
            seconds = ParsingHelpers.parseToDouble(parts[2]);
        }
        char directionChar = dmsFormat.charAt(dmsFormat.length() - 1);
        double sign = HaversineEquations.determineSign(directionChar, degrees);
        return sign * HaversineEquations.dmsToDegrees(degrees, minutes, seconds);
    }
}

