/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.thermodynamic;

import com.synerset.unitility.unitsystem.exceptions.UnitSystemParseException;
import com.synerset.unitility.unitsystem.thermodynamic.ThermalConductivityUnit;
import com.synerset.unitility.unitsystem.util.StringTransformer;
import java.util.function.DoubleUnaryOperator;

public enum ThermalConductivityUnits implements ThermalConductivityUnit
{
    WATTS_PER_METER_KELVIN("W/(m\u00b7K)", val -> val, val -> val),
    KILOWATTS_PER_METER_KELVIN("kW/(m\u00b7K)", val -> val * 1000.0, val -> val / 1000.0),
    BTU_PER_HOUR_FOOT_FAHRENHEIT("BTU/(h\u00b7ft\u00b7\u00b0F)", val -> val * 1.7307352822121, val -> val / 1.7307352822121);

    private final String symbol;
    private final DoubleUnaryOperator toBaseConverter;
    private final DoubleUnaryOperator fromBaseToUnitConverter;

    private ThermalConductivityUnits(String symbol, DoubleUnaryOperator toBaseConverter, DoubleUnaryOperator fromBaseToUnitConverter) {
        this.symbol = symbol;
        this.toBaseConverter = toBaseConverter;
        this.fromBaseToUnitConverter = fromBaseToUnitConverter;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public ThermalConductivityUnit getBaseUnit() {
        return WATTS_PER_METER_KELVIN;
    }

    @Override
    public double toValueInBaseUnit(double valueInThisUnit) {
        return this.toBaseConverter.applyAsDouble(valueInThisUnit);
    }

    @Override
    public double fromValueInBaseUnit(double valueInBaseUnit) {
        return this.fromBaseToUnitConverter.applyAsDouble(valueInBaseUnit);
    }

    public static ThermalConductivityUnit fromSymbol(String rawSymbol) {
        if (rawSymbol == null || rawSymbol.isBlank()) {
            return ThermalConductivityUnits.getDefaultUnit();
        }
        String requestedSymbol = ThermalConductivityUnits.unifySymbol(rawSymbol);
        for (ThermalConductivityUnits unit : ThermalConductivityUnits.values()) {
            String currentSymbol = ThermalConductivityUnits.unifySymbol(unit.getSymbol());
            if (!currentSymbol.equalsIgnoreCase(requestedSymbol)) continue;
            return unit;
        }
        throw new UnitSystemParseException("Unsupported unit symbol: {" + rawSymbol + "}. Target class: " + ThermalConductivityUnits.class.getSimpleName());
    }

    private static String unifySymbol(String inputString) {
        return StringTransformer.of(inputString).trimLowerAndClean().unifyMultiAndDiv().dropParentheses().dropDegreeSymbols().toString();
    }

    public static ThermalConductivityUnit getDefaultUnit() {
        return WATTS_PER_METER_KELVIN;
    }
}

