/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.thermodynamic;

import com.synerset.unitility.unitsystem.CalculableQuantity;
import com.synerset.unitility.unitsystem.thermodynamic.ThermalConductivityUnit;
import com.synerset.unitility.unitsystem.thermodynamic.ThermalConductivityUnits;
import java.util.Objects;

public class ThermalConductivity
implements CalculableQuantity<ThermalConductivityUnit, ThermalConductivity> {
    private final double value;
    private final double baseValue;
    private final ThermalConductivityUnit unitType;

    public ThermalConductivity(double value, ThermalConductivityUnit unitType) {
        this.value = value;
        if (unitType == null) {
            unitType = ThermalConductivityUnits.getDefaultUnit();
        }
        this.unitType = unitType;
        this.baseValue = unitType.toValueInBaseUnit(value);
    }

    public static ThermalConductivity of(double value, ThermalConductivityUnit unit) {
        return new ThermalConductivity(value, unit);
    }

    public static ThermalConductivity of(double value, String unitSymbol) {
        ThermalConductivityUnit resolvedUnit = ThermalConductivityUnits.fromSymbol(unitSymbol);
        return new ThermalConductivity(value, resolvedUnit);
    }

    public static ThermalConductivity ofWattsPerMeterKelvin(double value) {
        return new ThermalConductivity(value, ThermalConductivityUnits.WATTS_PER_METER_KELVIN);
    }

    public static ThermalConductivity ofKilowattsPerMeterKelvin(double value) {
        return new ThermalConductivity(value, ThermalConductivityUnits.KILOWATTS_PER_METER_KELVIN);
    }

    public static ThermalConductivity ofBTUPerHourFeetFahrenheit(double value) {
        return new ThermalConductivity(value, ThermalConductivityUnits.BTU_PER_HOUR_FOOT_FAHRENHEIT);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public ThermalConductivityUnit getUnitType() {
        return this.unitType;
    }

    public ThermalConductivity toBaseUnit() {
        double valueInWattsPerMeterKelvin = this.unitType.toValueInBaseUnit(this.value);
        return ThermalConductivity.of(valueInWattsPerMeterKelvin, ThermalConductivityUnits.WATTS_PER_METER_KELVIN);
    }

    public ThermalConductivity toUnit(ThermalConductivityUnit targetUnit) {
        double valueInWattsPerMeterKelvin = this.unitType.toValueInBaseUnit(this.value);
        double valueInTargetUnit = targetUnit.fromValueInBaseUnit(valueInWattsPerMeterKelvin);
        return ThermalConductivity.of(valueInTargetUnit, targetUnit);
    }

    @Override
    public ThermalConductivity withValue(double value) {
        return ThermalConductivity.of(value, this.unitType);
    }

    public ThermalConductivity toWattsPerMeterKelvin() {
        return this.toUnit(ThermalConductivityUnits.WATTS_PER_METER_KELVIN);
    }

    public ThermalConductivity toKilowattsPerMeterKelvin() {
        return this.toUnit(ThermalConductivityUnits.KILOWATTS_PER_METER_KELVIN);
    }

    public ThermalConductivity toBTUPerHourFeetFahrenheit() {
        return this.toUnit(ThermalConductivityUnits.BTU_PER_HOUR_FOOT_FAHRENHEIT);
    }

    public double getInWattsPerMeterKelvin() {
        return this.getInUnit(ThermalConductivityUnits.WATTS_PER_METER_KELVIN);
    }

    public double getInKilowattsPerMeterKelvin() {
        return this.getInUnit(ThermalConductivityUnits.KILOWATTS_PER_METER_KELVIN);
    }

    public double getInBTUsPerHourFeetFahrenheit() {
        return this.getInUnit(ThermalConductivityUnits.BTU_PER_HOUR_FOOT_FAHRENHEIT);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThermalConductivity inputQuantity = (ThermalConductivity)o;
        return Double.compare(inputQuantity.toBaseUnit().getValue(), this.baseValue) == 0 && Objects.equals(this.unitType.getBaseUnit(), inputQuantity.getUnitType().getBaseUnit());
    }

    public int hashCode() {
        return Objects.hash(this.baseValue, this.unitType.getBaseUnit());
    }

    public String toString() {
        return "ThermalConductivity{" + this.value + " " + this.unitType.getSymbol() + "}";
    }
}

