/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.thermodynamic;

import com.synerset.unitility.unitsystem.exceptions.UnitSystemParseException;
import com.synerset.unitility.unitsystem.thermodynamic.TemperatureUnit;
import com.synerset.unitility.unitsystem.util.StringTransformer;
import java.util.function.DoubleUnaryOperator;

public enum TemperatureUnits implements TemperatureUnit
{
    KELVIN("K", val -> val, val -> val),
    CELSIUS("\u00b0C", val -> val + 273.15, val -> val - 273.15),
    FAHRENHEIT("\u00b0F", val -> (val - 32.0) * 0.5555555555555556 + 273.15, val -> (val - 273.15) * 1.8 + 32.0);

    private final String symbol;
    private final DoubleUnaryOperator toBaseConverter;
    private final DoubleUnaryOperator fromBaseToUnitConverter;

    private TemperatureUnits(String symbol, DoubleUnaryOperator toBaseConverter, DoubleUnaryOperator fromBaseToUnitConverter) {
        this.symbol = symbol;
        this.toBaseConverter = toBaseConverter;
        this.fromBaseToUnitConverter = fromBaseToUnitConverter;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public TemperatureUnit getBaseUnit() {
        return KELVIN;
    }

    @Override
    public double toValueInBaseUnit(double valueInThisUnit) {
        return this.toBaseConverter.applyAsDouble(valueInThisUnit);
    }

    @Override
    public double fromValueInBaseUnit(double valueInBaseUnit) {
        return this.fromBaseToUnitConverter.applyAsDouble(valueInBaseUnit);
    }

    public static TemperatureUnit fromSymbol(String rawSymbol) {
        if (rawSymbol == null || rawSymbol.isBlank()) {
            return TemperatureUnits.getDefaultUnit();
        }
        String requestedSymbol = TemperatureUnits.unifySymbol(rawSymbol);
        for (TemperatureUnits unit : TemperatureUnits.values()) {
            String currentSymbol = TemperatureUnits.unifySymbol(unit.getSymbol());
            if (!currentSymbol.equalsIgnoreCase(requestedSymbol)) continue;
            return unit;
        }
        throw new UnitSystemParseException("Unsupported unit symbol: {" + rawSymbol + "}. Target class: " + TemperatureUnits.class.getSimpleName());
    }

    private static String unifySymbol(String inputString) {
        return StringTransformer.of(inputString).trimLowerAndClean().dropDegreeSymbols().toString();
    }

    public static TemperatureUnit getDefaultUnit() {
        return CELSIUS;
    }
}

