/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.thermodynamic;

import com.synerset.unitility.unitsystem.exceptions.UnitSystemParseException;
import com.synerset.unitility.unitsystem.thermodynamic.SpecificHeatUnit;
import com.synerset.unitility.unitsystem.util.StringTransformer;
import java.util.function.DoubleUnaryOperator;

public enum SpecificHeatUnits implements SpecificHeatUnit
{
    JOULES_PER_KILOGRAM_KELVIN("J/(kg\u00b7K)", val -> val, val -> val),
    KILOJOULES_PER_KILOGRAM_KELVIN("kJ/(kg\u00b7K)", val -> val * 1000.0, val -> val / 1000.0),
    BTU_PER_POUND_FAHRENHEIT("BTU/(lb\u00b7\u00b0F)", val -> val * 4186.7999934703, val -> val / 4186.7999934703);

    private final String symbol;
    private final DoubleUnaryOperator toBaseConverter;
    private final DoubleUnaryOperator fromBaseToUnitConverter;

    private SpecificHeatUnits(String symbol, DoubleUnaryOperator toBaseConverter, DoubleUnaryOperator fromBaseToUnitConverter) {
        this.symbol = symbol;
        this.toBaseConverter = toBaseConverter;
        this.fromBaseToUnitConverter = fromBaseToUnitConverter;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public SpecificHeatUnit getBaseUnit() {
        return JOULES_PER_KILOGRAM_KELVIN;
    }

    @Override
    public double toValueInBaseUnit(double valueInThisUnit) {
        return this.toBaseConverter.applyAsDouble(valueInThisUnit);
    }

    @Override
    public double fromValueInBaseUnit(double valueInBaseUnit) {
        return this.fromBaseToUnitConverter.applyAsDouble(valueInBaseUnit);
    }

    public static SpecificHeatUnit fromSymbol(String rawSymbol) {
        if (rawSymbol == null || rawSymbol.isBlank()) {
            return SpecificHeatUnits.getDefaultUnit();
        }
        String requestedSymbol = SpecificHeatUnits.unifySymbol(rawSymbol);
        for (SpecificHeatUnits unit : SpecificHeatUnits.values()) {
            String currentSymbol = SpecificHeatUnits.unifySymbol(unit.getSymbol());
            if (!currentSymbol.equalsIgnoreCase(requestedSymbol)) continue;
            return unit;
        }
        throw new UnitSystemParseException("Unsupported unit symbol: {" + rawSymbol + "}. Target class: " + SpecificHeatUnits.class.getSimpleName());
    }

    private static String unifySymbol(String inputString) {
        return StringTransformer.of(inputString).trimLowerAndClean().unifyMultiAndDiv().dropParentheses().unifySymbolsOfAngle().toString();
    }

    public static SpecificHeatUnit getDefaultUnit() {
        return JOULES_PER_KILOGRAM_KELVIN;
    }
}

