/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.thermodynamic;

import com.synerset.unitility.unitsystem.CalculableQuantity;
import com.synerset.unitility.unitsystem.thermodynamic.SpecificHeatUnit;
import com.synerset.unitility.unitsystem.thermodynamic.SpecificHeatUnits;
import java.util.Objects;

public class SpecificHeat
implements CalculableQuantity<SpecificHeatUnit, SpecificHeat> {
    private final double value;
    private final double baseValue;
    private final SpecificHeatUnit unitType;

    public SpecificHeat(double value, SpecificHeatUnit unitType) {
        this.value = value;
        if (unitType == null) {
            unitType = SpecificHeatUnits.getDefaultUnit();
        }
        this.unitType = unitType;
        this.baseValue = unitType.toValueInBaseUnit(value);
    }

    public static SpecificHeat of(double value, SpecificHeatUnit unit) {
        return new SpecificHeat(value, unit);
    }

    public static SpecificHeat of(double value, String unitSymbol) {
        SpecificHeatUnit resolvedUnit = SpecificHeatUnits.fromSymbol(unitSymbol);
        return new SpecificHeat(value, resolvedUnit);
    }

    public static SpecificHeat ofJoulePerKiloGramKelvin(double value) {
        return new SpecificHeat(value, SpecificHeatUnits.JOULES_PER_KILOGRAM_KELVIN);
    }

    public static SpecificHeat ofKiloJoulePerKiloGramKelvin(double value) {
        return new SpecificHeat(value, SpecificHeatUnits.KILOJOULES_PER_KILOGRAM_KELVIN);
    }

    public static SpecificHeat ofBTUPerPoundFahrenheit(double value) {
        return new SpecificHeat(value, SpecificHeatUnits.BTU_PER_POUND_FAHRENHEIT);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public SpecificHeatUnit getUnitType() {
        return this.unitType;
    }

    public SpecificHeat toBaseUnit() {
        double valueInJoulePerKiloGramKelvin = this.unitType.toValueInBaseUnit(this.value);
        return SpecificHeat.of(valueInJoulePerKiloGramKelvin, SpecificHeatUnits.JOULES_PER_KILOGRAM_KELVIN);
    }

    public SpecificHeat toUnit(SpecificHeatUnit targetUnit) {
        double valueInJoulePerKiloGramKelvin = this.unitType.toValueInBaseUnit(this.value);
        double valueInTargetUnit = targetUnit.fromValueInBaseUnit(valueInJoulePerKiloGramKelvin);
        return SpecificHeat.of(valueInTargetUnit, targetUnit);
    }

    @Override
    public SpecificHeat withValue(double value) {
        return SpecificHeat.of(value, this.unitType);
    }

    public SpecificHeat toJoulePerKiloGramKelvin() {
        return this.toUnit(SpecificHeatUnits.JOULES_PER_KILOGRAM_KELVIN);
    }

    public SpecificHeat toKiloJoulePerKiloGramKelvin() {
        return this.toUnit(SpecificHeatUnits.KILOJOULES_PER_KILOGRAM_KELVIN);
    }

    public SpecificHeat toBTUPerPoundFahrenheit() {
        return this.toUnit(SpecificHeatUnits.BTU_PER_POUND_FAHRENHEIT);
    }

    public double getInJoulePerKiloGramKelvin() {
        return this.getInUnit(SpecificHeatUnits.JOULES_PER_KILOGRAM_KELVIN);
    }

    public double getInKiloJoulesPerKiloGramKelvin() {
        return this.getInUnit(SpecificHeatUnits.KILOJOULES_PER_KILOGRAM_KELVIN);
    }

    public double getInBTUsPerPoundFahrenheit() {
        return this.getInUnit(SpecificHeatUnits.BTU_PER_POUND_FAHRENHEIT);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpecificHeat inputQuantity = (SpecificHeat)o;
        return Double.compare(inputQuantity.toBaseUnit().getValue(), this.baseValue) == 0 && Objects.equals(this.unitType.getBaseUnit(), inputQuantity.getUnitType().getBaseUnit());
    }

    public int hashCode() {
        return Objects.hash(this.baseValue, this.unitType.getBaseUnit());
    }

    public String toString() {
        return "SpecificHeat{" + this.value + " " + this.unitType.getSymbol() + "}";
    }
}

