/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.thermodynamic;

import com.synerset.unitility.unitsystem.CalculableQuantity;
import com.synerset.unitility.unitsystem.thermodynamic.SpecificEnthalpyUnit;
import com.synerset.unitility.unitsystem.thermodynamic.SpecificEnthalpyUnits;
import java.util.Objects;

public class SpecificEnthalpy
implements CalculableQuantity<SpecificEnthalpyUnit, SpecificEnthalpy> {
    private final double value;
    private final double baseValue;
    private final SpecificEnthalpyUnit unitType;

    public SpecificEnthalpy(double value, SpecificEnthalpyUnit unitType) {
        this.value = value;
        if (unitType == null) {
            unitType = SpecificEnthalpyUnits.getDefaultUnit();
        }
        this.unitType = unitType;
        this.baseValue = unitType.toValueInBaseUnit(value);
    }

    public static SpecificEnthalpy of(double value, SpecificEnthalpyUnit unit) {
        return new SpecificEnthalpy(value, unit);
    }

    public static SpecificEnthalpy of(double value, String unitSymbol) {
        SpecificEnthalpyUnit resolvedUnit = SpecificEnthalpyUnits.fromSymbol(unitSymbol);
        return new SpecificEnthalpy(value, resolvedUnit);
    }

    public static SpecificEnthalpy ofJoulePerKiloGram(double value) {
        return new SpecificEnthalpy(value, SpecificEnthalpyUnits.JOULE_PER_KILOGRAM);
    }

    public static SpecificEnthalpy ofKiloJoulePerKiloGram(double value) {
        return new SpecificEnthalpy(value, SpecificEnthalpyUnits.KILOJOULE_PER_KILOGRAM);
    }

    public static SpecificEnthalpy ofBTUPerPound(double value) {
        return new SpecificEnthalpy(value, SpecificEnthalpyUnits.BTU_PER_POUND);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public SpecificEnthalpyUnit getUnitType() {
        return this.unitType;
    }

    public SpecificEnthalpy toBaseUnit() {
        double valueInJoulePerKilogram = this.unitType.toValueInBaseUnit(this.value);
        return SpecificEnthalpy.of(valueInJoulePerKilogram, SpecificEnthalpyUnits.JOULE_PER_KILOGRAM);
    }

    public SpecificEnthalpy toUnit(SpecificEnthalpyUnit targetUnit) {
        double valueInJoulePerKilogram = this.unitType.toValueInBaseUnit(this.value);
        double valueInTargetUnit = targetUnit.fromValueInBaseUnit(valueInJoulePerKilogram);
        return SpecificEnthalpy.of(valueInTargetUnit, targetUnit);
    }

    @Override
    public SpecificEnthalpy withValue(double value) {
        return SpecificEnthalpy.of(value, this.unitType);
    }

    public SpecificEnthalpy toJoulePerKiloGram() {
        return this.toUnit(SpecificEnthalpyUnits.JOULE_PER_KILOGRAM);
    }

    public SpecificEnthalpy toKiloJoulePerKiloGram() {
        return this.toUnit(SpecificEnthalpyUnits.KILOJOULE_PER_KILOGRAM);
    }

    public SpecificEnthalpy toBTUPerPound() {
        return this.toUnit(SpecificEnthalpyUnits.BTU_PER_POUND);
    }

    public double getInJoulesPerKiloGram() {
        return this.getInUnit(SpecificEnthalpyUnits.JOULE_PER_KILOGRAM);
    }

    public double getInKiloJoulesPerKiloGram() {
        return this.getInUnit(SpecificEnthalpyUnits.KILOJOULE_PER_KILOGRAM);
    }

    public double getInBTUsPerPound() {
        return this.getInUnit(SpecificEnthalpyUnits.BTU_PER_POUND);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpecificEnthalpy inputQuantity = (SpecificEnthalpy)o;
        return Double.compare(inputQuantity.toBaseUnit().getValue(), this.baseValue) == 0 && Objects.equals(this.unitType.getBaseUnit(), inputQuantity.getUnitType().getBaseUnit());
    }

    public int hashCode() {
        return Objects.hash(this.baseValue, this.unitType.getBaseUnit());
    }

    public String toString() {
        return "SpecificEnthalpy{" + this.value + " " + this.unitType.getSymbol() + "}";
    }
}

