/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.thermodynamic;

import com.synerset.unitility.unitsystem.CalculableQuantity;
import com.synerset.unitility.unitsystem.thermodynamic.PowerUnit;
import com.synerset.unitility.unitsystem.thermodynamic.PowerUnits;
import java.util.Objects;

public class Power
implements CalculableQuantity<PowerUnit, Power> {
    private final double value;
    private final double baseValue;
    private final PowerUnit unitType;

    public Power(double value, PowerUnit unitType) {
        this.value = value;
        if (unitType == null) {
            unitType = PowerUnits.getDefaultUnit();
        }
        this.unitType = unitType;
        this.baseValue = unitType.toValueInBaseUnit(value);
    }

    public static Power of(double value, PowerUnit unit) {
        return new Power(value, unit);
    }

    public static Power of(double value, String unitSymbol) {
        PowerUnit resolvedUnit = PowerUnits.fromSymbol(unitSymbol);
        return new Power(value, resolvedUnit);
    }

    public static Power ofWatts(double value) {
        return new Power(value, PowerUnits.WATT);
    }

    public static Power ofKiloWatts(double value) {
        return new Power(value, PowerUnits.KILOWATT);
    }

    public static Power ofMegaWatts(double value) {
        return new Power(value, PowerUnits.MEGAWATT);
    }

    public static Power ofBTUPerHour(double value) {
        return new Power(value, PowerUnits.BTU_PER_HOUR);
    }

    public static Power ofHorsePower(double value) {
        return new Power(value, PowerUnits.HORSE_POWER);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public PowerUnit getUnitType() {
        return this.unitType;
    }

    public Power toBaseUnit() {
        double valueInWatts = this.unitType.toValueInBaseUnit(this.value);
        return Power.of(valueInWatts, PowerUnits.WATT);
    }

    public Power toUnit(PowerUnit targetUnit) {
        double valueInWatts = this.unitType.toValueInBaseUnit(this.value);
        double valueInTargetUnit = targetUnit.fromValueInBaseUnit(valueInWatts);
        return Power.of(valueInTargetUnit, targetUnit);
    }

    @Override
    public Power withValue(double value) {
        return Power.of(value, this.unitType);
    }

    public Power toWatts() {
        return this.toUnit(PowerUnits.WATT);
    }

    public Power toKiloWatts() {
        return this.toUnit(PowerUnits.KILOWATT);
    }

    public Power toBTUPerHour() {
        return this.toUnit(PowerUnits.BTU_PER_HOUR);
    }

    public Power toMegaWatts() {
        return this.toUnit(PowerUnits.MEGAWATT);
    }

    public Power toHorsePower() {
        return this.toUnit(PowerUnits.HORSE_POWER);
    }

    public double getInWatts() {
        return this.getInUnit(PowerUnits.WATT);
    }

    public double getInKiloWatts() {
        return this.getInUnit(PowerUnits.KILOWATT);
    }

    public double getInBTUPerHour() {
        return this.getInUnit(PowerUnits.BTU_PER_HOUR);
    }

    public double getInMegaWatts() {
        return this.getInUnit(PowerUnits.MEGAWATT);
    }

    public double getInHorsePower() {
        return this.getInUnit(PowerUnits.HORSE_POWER);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Power inputQuantity = (Power)o;
        return Double.compare(inputQuantity.toBaseUnit().getValue(), this.baseValue) == 0 && Objects.equals(this.unitType.getBaseUnit(), inputQuantity.getUnitType().getBaseUnit());
    }

    public int hashCode() {
        return Objects.hash(this.baseValue, this.unitType.getBaseUnit());
    }

    public String toString() {
        return "Power{" + this.value + " " + this.unitType.getSymbol() + "}";
    }
}

