/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.thermodynamic;

import com.synerset.unitility.unitsystem.CalculableQuantity;
import com.synerset.unitility.unitsystem.thermodynamic.EnergyUnit;
import com.synerset.unitility.unitsystem.thermodynamic.EnergyUnits;
import java.util.Objects;

public class Energy
implements CalculableQuantity<EnergyUnit, Energy> {
    private final double value;
    private final double baseValue;
    private final EnergyUnit unitType;

    public Energy(double value, EnergyUnit unitType) {
        this.value = value;
        if (unitType == null) {
            unitType = EnergyUnits.getDefaultUnit();
        }
        this.unitType = unitType;
        this.baseValue = unitType.toValueInBaseUnit(value);
    }

    public static Energy of(double value, EnergyUnit unit) {
        return new Energy(value, unit);
    }

    public static Energy of(double value, String unitSymbol) {
        EnergyUnit resolvedUnit = EnergyUnits.fromSymbol(unitSymbol);
        return new Energy(value, resolvedUnit);
    }

    public static Energy ofJoules(double value) {
        return new Energy(value, EnergyUnits.JOULE);
    }

    public static Energy ofMilliJoules(double value) {
        return new Energy(value, EnergyUnits.MILLIJOULE);
    }

    public static Energy ofKiloJoules(double value) {
        return new Energy(value, EnergyUnits.KILOJOULE);
    }

    public static Energy ofMegaJoules(double value) {
        return new Energy(value, EnergyUnits.MEGAJOULE);
    }

    public static Energy ofBTU(double value) {
        return new Energy(value, EnergyUnits.BTU);
    }

    public static Energy ofCalorie(double value) {
        return new Energy(value, EnergyUnits.CALORIE);
    }

    public static Energy ofKiloCalorie(double value) {
        return new Energy(value, EnergyUnits.KILOCALORIE);
    }

    public static Energy ofWattHour(double value) {
        return new Energy(value, EnergyUnits.WATT_HOUR);
    }

    public static Energy ofKilowattHour(double value) {
        return new Energy(value, EnergyUnits.KILOWATT_HOUR);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public EnergyUnit getUnitType() {
        return this.unitType;
    }

    public Energy toBaseUnit() {
        double valueInJoules = this.unitType.toValueInBaseUnit(this.value);
        return Energy.of(valueInJoules, EnergyUnits.JOULE);
    }

    public Energy toUnit(EnergyUnit targetUnit) {
        double valueInJoules = this.unitType.toValueInBaseUnit(this.value);
        double valueInTargetUnit = targetUnit.fromValueInBaseUnit(valueInJoules);
        return Energy.of(valueInTargetUnit, targetUnit);
    }

    @Override
    public Energy withValue(double value) {
        return Energy.of(value, this.unitType);
    }

    public Energy toJoules() {
        return this.toUnit(EnergyUnits.JOULE);
    }

    public Energy toMilliJoules() {
        return this.toUnit(EnergyUnits.MILLIJOULE);
    }

    public Energy toKiloJoules() {
        return this.toUnit(EnergyUnits.KILOJOULE);
    }

    public Energy toMegaJoules() {
        return this.toUnit(EnergyUnits.MEGAJOULE);
    }

    public Energy toBTU() {
        return this.toUnit(EnergyUnits.BTU);
    }

    public Energy toCalories() {
        return this.toUnit(EnergyUnits.CALORIE);
    }

    public Energy toKiloCalories() {
        return this.toUnit(EnergyUnits.KILOCALORIE);
    }

    public Energy toWattHour() {
        return this.toUnit(EnergyUnits.WATT_HOUR);
    }

    public Energy toKilowattHour() {
        return this.toUnit(EnergyUnits.KILOWATT_HOUR);
    }

    public double getInJoules() {
        return this.getInUnit(EnergyUnits.JOULE);
    }

    public double getInMilliJoules() {
        return this.getInUnit(EnergyUnits.MILLIJOULE);
    }

    public double getInKiloJoules() {
        return this.getInUnit(EnergyUnits.KILOJOULE);
    }

    public double getInMegaJoules() {
        return this.getInUnit(EnergyUnits.MEGAJOULE);
    }

    public double getInBTUs() {
        return this.getInUnit(EnergyUnits.BTU);
    }

    public double getInCalories() {
        return this.getInUnit(EnergyUnits.CALORIE);
    }

    public double getInKiloCalories() {
        return this.getInUnit(EnergyUnits.KILOCALORIE);
    }

    public double getInWattHours() {
        return this.getInUnit(EnergyUnits.WATT_HOUR);
    }

    public double getInKilowattHours() {
        return this.getInUnit(EnergyUnits.KILOWATT_HOUR);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Energy inputQuantity = (Energy)o;
        return Double.compare(inputQuantity.toBaseUnit().getValue(), this.baseValue) == 0 && Objects.equals(this.unitType.getBaseUnit(), inputQuantity.getUnitType().getBaseUnit());
    }

    public int hashCode() {
        return Objects.hash(this.baseValue, this.unitType.getBaseUnit());
    }

    public String toString() {
        return "Energy{" + this.value + " " + this.unitType.getSymbol() + "}";
    }
}

