/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.thermodynamic;

import com.synerset.unitility.unitsystem.exceptions.UnitSystemParseException;
import com.synerset.unitility.unitsystem.thermodynamic.DensityUnit;
import com.synerset.unitility.unitsystem.util.StringTransformer;
import java.util.function.DoubleUnaryOperator;

public enum DensityUnits implements DensityUnit
{
    KILOGRAM_PER_CUBIC_METER("kg/m\u00b3", val -> val, val -> val),
    POUND_PER_CUBIC_FOOT("lb/ft\u00b3", val -> val * 16.0184633739599, val -> val / 16.0184633739599),
    POUND_PER_CUBIC_INCH("lb/in\u00b3", val -> val / 3.6127292218E-5, val -> val * 3.6127292218E-5);

    private final String symbol;
    private final DoubleUnaryOperator toBaseConverter;
    private final DoubleUnaryOperator fromBaseToUnitConverter;

    private DensityUnits(String symbol, DoubleUnaryOperator toBaseConverter, DoubleUnaryOperator fromBaseToUnitConverter) {
        this.symbol = symbol;
        this.toBaseConverter = toBaseConverter;
        this.fromBaseToUnitConverter = fromBaseToUnitConverter;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public DensityUnit getBaseUnit() {
        return KILOGRAM_PER_CUBIC_METER;
    }

    @Override
    public double toValueInBaseUnit(double valueInThisUnit) {
        return this.toBaseConverter.applyAsDouble(valueInThisUnit);
    }

    @Override
    public double fromValueInBaseUnit(double valueInBaseUnit) {
        return this.fromBaseToUnitConverter.applyAsDouble(valueInBaseUnit);
    }

    public static DensityUnit fromSymbol(String rawSymbol) {
        if (rawSymbol == null || rawSymbol.isBlank()) {
            return DensityUnits.getDefaultUnit();
        }
        String requestedSymbol = DensityUnits.unifySymbol(rawSymbol);
        for (DensityUnits unit : DensityUnits.values()) {
            String currentSymbol = DensityUnits.unifySymbol(unit.getSymbol());
            if (!currentSymbol.equalsIgnoreCase(requestedSymbol)) continue;
            return unit;
        }
        throw new UnitSystemParseException("Unsupported unit symbol: {" + rawSymbol + "}. Target class: " + DensityUnits.class.getSimpleName());
    }

    private static String unifySymbol(String inputString) {
        return StringTransformer.of(inputString).trimLowerAndClean().unifyMultiAndDiv().unifyAerialAndVol().toString();
    }

    public static DensityUnit getDefaultUnit() {
        return KILOGRAM_PER_CUBIC_METER;
    }
}

