/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.thermodynamic;

import com.synerset.unitility.unitsystem.CalculableQuantity;
import com.synerset.unitility.unitsystem.thermodynamic.DensityUnit;
import com.synerset.unitility.unitsystem.thermodynamic.DensityUnits;
import java.util.Objects;

public class Density
implements CalculableQuantity<DensityUnit, Density> {
    public static final Density PHYSICAL_MIN_LIMIT = Density.ofKilogramPerCubicMeter(0.0);
    private final double value;
    private final double baseValue;
    private final DensityUnit unitType;

    public Density(double value, DensityUnit unitType) {
        this.value = value;
        if (unitType == null) {
            unitType = DensityUnits.getDefaultUnit();
        }
        this.unitType = unitType;
        this.baseValue = unitType.toValueInBaseUnit(value);
    }

    public static Density of(double value, DensityUnit unit) {
        return new Density(value, unit);
    }

    public static Density of(double value, String unitSymbol) {
        DensityUnit resolvedUnit = DensityUnits.fromSymbol(unitSymbol);
        return new Density(value, resolvedUnit);
    }

    public static Density ofKilogramPerCubicMeter(double value) {
        return new Density(value, DensityUnits.KILOGRAM_PER_CUBIC_METER);
    }

    public static Density ofPoundPerCubicFoot(double value) {
        return new Density(value, DensityUnits.POUND_PER_CUBIC_FOOT);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public DensityUnit getUnitType() {
        return this.unitType;
    }

    public Density toBaseUnit() {
        double valueInKGpM3 = this.unitType.toValueInBaseUnit(this.value);
        return Density.of(valueInKGpM3, DensityUnits.KILOGRAM_PER_CUBIC_METER);
    }

    public Density toUnit(DensityUnit targetUnit) {
        double valueInKGpM3 = this.unitType.toValueInBaseUnit(this.value);
        double valueInTargetUnit = targetUnit.fromValueInBaseUnit(valueInKGpM3);
        return Density.of(valueInTargetUnit, targetUnit);
    }

    @Override
    public Density withValue(double value) {
        return Density.of(value, this.unitType);
    }

    public Density toKilogramPerCubicMeter() {
        return this.toUnit(DensityUnits.KILOGRAM_PER_CUBIC_METER);
    }

    public Density toPoundPerCubicFoot() {
        return this.toUnit(DensityUnits.POUND_PER_CUBIC_FOOT);
    }

    public double getInKilogramsPerCubicMeters() {
        return this.getInUnit(DensityUnits.KILOGRAM_PER_CUBIC_METER);
    }

    public double getInPoundsPerCubicFoot() {
        return this.getInUnit(DensityUnits.POUND_PER_CUBIC_FOOT);
    }

    public double getInPoundsPerCubicInches() {
        return this.getInUnit(DensityUnits.POUND_PER_CUBIC_INCH);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Density inputQuantity = (Density)o;
        return Double.compare(inputQuantity.toBaseUnit().getValue(), this.baseValue) == 0 && Objects.equals(this.unitType.getBaseUnit(), inputQuantity.getUnitType().getBaseUnit());
    }

    public int hashCode() {
        return Objects.hash(this.baseValue, this.unitType.getBaseUnit());
    }

    public String toString() {
        return "Density{" + this.value + " " + this.unitType.getSymbol() + "}";
    }
}

