/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.mechanical;

import com.synerset.unitility.unitsystem.exceptions.UnitSystemParseException;
import com.synerset.unitility.unitsystem.mechanical.TorqueUnit;
import com.synerset.unitility.unitsystem.util.StringTransformer;
import java.util.function.DoubleUnaryOperator;

public enum TorqueUnits implements TorqueUnit
{
    NEWTON_METER("N\u00b7m", val -> val, val -> val),
    MILLINEWTON_METER("mN\u00b7m", val -> val * 0.001, val -> val * 1000.0),
    KILOPOND_METER("kp\u00b7m", val -> val * 9.80665, val -> val / 9.80665),
    FOOT_POUND("ft\u00b7lb", val -> val * 1.3558179483314003, val -> val / 1.3558179483314003),
    INCH_POUND("in\u00b7lb", val -> val * 0.1129848290276167, val -> val / 0.1129848290276167);

    private final String symbol;
    private final DoubleUnaryOperator toBaseConverter;
    private final DoubleUnaryOperator fromBaseToUnitConverter;

    private TorqueUnits(String symbol, DoubleUnaryOperator toBaseConverter, DoubleUnaryOperator fromBaseToUnitConverter) {
        this.symbol = symbol;
        this.toBaseConverter = toBaseConverter;
        this.fromBaseToUnitConverter = fromBaseToUnitConverter;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public TorqueUnits getBaseUnit() {
        return NEWTON_METER;
    }

    @Override
    public double toValueInBaseUnit(double valueInThisUnit) {
        return this.toBaseConverter.applyAsDouble(valueInThisUnit);
    }

    @Override
    public double fromValueInBaseUnit(double valueInBaseUnit) {
        return this.fromBaseToUnitConverter.applyAsDouble(valueInBaseUnit);
    }

    public static TorqueUnit fromSymbol(String rawSymbol) {
        if (rawSymbol == null || rawSymbol.isBlank()) {
            return TorqueUnits.getDefaultUnit();
        }
        String requestedSymbol = TorqueUnits.unifySymbol(rawSymbol);
        for (TorqueUnits unit : TorqueUnits.values()) {
            String currentSymbol = TorqueUnits.unifySymbol(unit.getSymbol());
            if (!currentSymbol.equalsIgnoreCase(requestedSymbol)) continue;
            return unit;
        }
        throw new UnitSystemParseException("Unsupported unit symbol: {" + rawSymbol + "}. Target class: " + TorqueUnits.class.getSimpleName());
    }

    private static String unifySymbol(String inputString) {
        return StringTransformer.of(inputString).trimLowerAndClean().unifyMultiAndDiv().toString();
    }

    public static TorqueUnit getDefaultUnit() {
        return NEWTON_METER;
    }
}

