/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.mechanical;

import com.synerset.unitility.unitsystem.CalculableQuantity;
import com.synerset.unitility.unitsystem.mechanical.ForceUnit;
import com.synerset.unitility.unitsystem.mechanical.ForceUnits;
import java.util.Objects;

public class Force
implements CalculableQuantity<ForceUnit, Force> {
    private final double value;
    private final double baseValue;
    private final ForceUnit unitType;

    public Force(double value, ForceUnit unitType) {
        this.value = value;
        if (unitType == null) {
            unitType = ForceUnits.getDefaultUnit();
        }
        this.unitType = unitType;
        this.baseValue = unitType.toValueInBaseUnit(value);
    }

    public static Force of(double value, ForceUnit unit) {
        return new Force(value, unit);
    }

    public static Force of(double value, String unitSymbol) {
        ForceUnit resolvedUnit = ForceUnits.fromSymbol(unitSymbol);
        return new Force(value, resolvedUnit);
    }

    public static Force ofNewtons(double value) {
        return new Force(value, ForceUnits.NEWTON);
    }

    public static Force ofKiloNewtons(double value) {
        return new Force(value, ForceUnits.KILONEWTON);
    }

    public static Force ofKiloponds(double value) {
        return new Force(value, ForceUnits.KILOPOND);
    }

    public static Force ofDynes(double value) {
        return new Force(value, ForceUnits.DYNE);
    }

    public static Force ofPoundForce(double value) {
        return new Force(value, ForceUnits.POUND_FORCE);
    }

    public static Force ofPoundal(double value) {
        return new Force(value, ForceUnits.POUNDAL);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public ForceUnit getUnitType() {
        return this.unitType;
    }

    public Force toBaseUnit() {
        double valueInNewtons = this.unitType.toValueInBaseUnit(this.value);
        return Force.of(valueInNewtons, ForceUnits.NEWTON);
    }

    public Force toUnit(ForceUnit targetUnit) {
        double valueInNewtons = this.unitType.toValueInBaseUnit(this.value);
        double valueInTargetUnit = targetUnit.fromValueInBaseUnit(valueInNewtons);
        return Force.of(valueInTargetUnit, targetUnit);
    }

    @Override
    public Force withValue(double value) {
        return Force.of(value, this.unitType);
    }

    public Force toNewtons() {
        return this.toUnit(ForceUnits.NEWTON);
    }

    public Force toKiloNewtons() {
        return this.toUnit(ForceUnits.KILONEWTON);
    }

    public Force toKiloponds() {
        return this.toUnit(ForceUnits.KILOPOND);
    }

    public Force toDynes() {
        return this.toUnit(ForceUnits.DYNE);
    }

    public Force toPoundForce() {
        return this.toUnit(ForceUnits.POUND_FORCE);
    }

    public Force toPoundal() {
        return this.toUnit(ForceUnits.POUNDAL);
    }

    public double getInNewtons() {
        return this.getInUnit(ForceUnits.NEWTON);
    }

    public double getInKiloNewtons() {
        return this.getInUnit(ForceUnits.KILONEWTON);
    }

    public double getInKiloponds() {
        return this.getInUnit(ForceUnits.KILOPOND);
    }

    public double getInDynes() {
        return this.getInUnit(ForceUnits.DYNE);
    }

    public double getInPoundsForce() {
        return this.getInUnit(ForceUnits.POUND_FORCE);
    }

    public double getInPoundals() {
        return this.getInUnit(ForceUnits.POUNDAL);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Force inputQuantity = (Force)o;
        return Double.compare(inputQuantity.toBaseUnit().getValue(), this.baseValue) == 0 && Objects.equals(this.unitType.getBaseUnit(), inputQuantity.getUnitType().getBaseUnit());
    }

    public int hashCode() {
        return Objects.hash(this.baseValue, this.unitType.getBaseUnit());
    }

    public String toString() {
        return "Force{" + this.value + " " + this.unitType.getSymbol() + "}";
    }
}

