/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.humidity;

import com.synerset.unitility.unitsystem.CalculableQuantity;
import com.synerset.unitility.unitsystem.humidity.HumidityRatioUnit;
import com.synerset.unitility.unitsystem.humidity.HumidityRatioUnits;
import java.util.Objects;

public class HumidityRatio
implements CalculableQuantity<HumidityRatioUnit, HumidityRatio> {
    public static final HumidityRatio HUM_RATIO_MIN_LIMIT = HumidityRatio.ofKilogramPerKilogram(0.0);
    private final double value;
    private final double baseValue;
    private final HumidityRatioUnit unitType;

    public HumidityRatio(double value, HumidityRatioUnit unitType) {
        this.value = value;
        if (unitType == null) {
            unitType = HumidityRatioUnits.getDefaultUnit();
        }
        this.unitType = unitType;
        this.baseValue = unitType.toValueInBaseUnit(value);
    }

    public static HumidityRatio of(double value, HumidityRatioUnit unit) {
        return new HumidityRatio(value, unit);
    }

    public static HumidityRatio of(double value, String unitSymbol) {
        HumidityRatioUnit resolvedUnit = HumidityRatioUnits.fromSymbol(unitSymbol);
        return new HumidityRatio(value, resolvedUnit);
    }

    public static HumidityRatio ofKilogramPerKilogram(double value) {
        return new HumidityRatio(value, HumidityRatioUnits.KILOGRAM_PER_KILOGRAM);
    }

    public static HumidityRatio ofPoundPerPound(double value) {
        return new HumidityRatio(value, HumidityRatioUnits.POUND_PER_POUND);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public HumidityRatioUnit getUnitType() {
        return this.unitType;
    }

    public HumidityRatio toBaseUnit() {
        double valueInKgKg = this.unitType.toValueInBaseUnit(this.value);
        return HumidityRatio.of(valueInKgKg, HumidityRatioUnits.KILOGRAM_PER_KILOGRAM);
    }

    public HumidityRatio toUnit(HumidityRatioUnit targetUnit) {
        double valueInKgKg = this.unitType.toValueInBaseUnit(this.value);
        double valueInTargetUnit = targetUnit.fromValueInBaseUnit(valueInKgKg);
        return HumidityRatio.of(valueInTargetUnit, targetUnit);
    }

    @Override
    public HumidityRatio withValue(double value) {
        return HumidityRatio.of(value, this.unitType);
    }

    public HumidityRatio toKilogramPerKilogram() {
        return this.toUnit(HumidityRatioUnits.KILOGRAM_PER_KILOGRAM);
    }

    public HumidityRatio toPoundPerPound() {
        return this.toUnit(HumidityRatioUnits.POUND_PER_POUND);
    }

    public double getInKilogramPerKilogram() {
        return this.getInUnit(HumidityRatioUnits.KILOGRAM_PER_KILOGRAM);
    }

    public double getInPoundPerPound() {
        return this.getInUnit(HumidityRatioUnits.POUND_PER_POUND);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HumidityRatio inputQuantity = (HumidityRatio)o;
        return Double.compare(inputQuantity.toBaseUnit().getValue(), this.baseValue) == 0 && Objects.equals(this.unitType.getBaseUnit(), inputQuantity.getUnitType().getBaseUnit());
    }

    public int hashCode() {
        return Objects.hash(this.baseValue, this.unitType.getBaseUnit());
    }

    public String toString() {
        return "HumidityRatio{" + this.value + " " + this.unitType.getSymbol() + "}";
    }
}

