/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.geographic;

import com.synerset.unitility.unitsystem.CalculableQuantity;
import com.synerset.unitility.unitsystem.common.AngleUnit;
import com.synerset.unitility.unitsystem.common.AngleUnits;
import com.synerset.unitility.unitsystem.geographic.CardinalDirection;
import com.synerset.unitility.unitsystem.geographic.DMSValueFormatter;
import com.synerset.unitility.unitsystem.geographic.HaversineEquations;
import java.util.Objects;

public class Longitude
implements CalculableQuantity<AngleUnit, Longitude> {
    public static final Longitude MIN_EARTH_LONGITUDE = Longitude.ofDegrees(-180.0);
    public static final Longitude MAX_EARTH_LONGITUDE = Longitude.ofDegrees(180.0);
    private final double value;
    private final double baseValue;
    private final AngleUnit unitType;

    public Longitude(double value, AngleUnit unitType) {
        this.value = value;
        if (unitType == null) {
            unitType = AngleUnits.getDefaultUnit();
        }
        this.unitType = unitType;
        this.baseValue = unitType.toValueInBaseUnit(value);
    }

    public static Longitude of(double value, AngleUnit unit) {
        return new Longitude(value, unit);
    }

    public static Longitude of(double value, String unitSymbol) {
        AngleUnit resolvedUnit = AngleUnits.fromSymbol(unitSymbol);
        return new Longitude(value, resolvedUnit);
    }

    public static Longitude ofRadians(double value) {
        return new Longitude(value, AngleUnits.RADIANS);
    }

    public static Longitude ofDegrees(double value) {
        return new Longitude(value, AngleUnits.DEGREES);
    }

    public static Longitude ofDegMinSec(int degrees, int minutes, double seconds) {
        double decimalDegrees = HaversineEquations.dmsToDegrees(degrees, minutes, seconds);
        double decimalDegreesWithSign = degrees > 0 ? decimalDegrees : decimalDegrees * -1.0;
        return Longitude.ofDegrees(decimalDegreesWithSign);
    }

    public static Longitude ofDegMinSec(int degrees, int minutes, double seconds, CardinalDirection direction) {
        double sign = HaversineEquations.determineSign(direction.getDirectionChar(), degrees);
        double decimalDegrees = HaversineEquations.dmsToDegrees(degrees, minutes, seconds);
        return Longitude.ofDegrees(sign * decimalDegrees);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public AngleUnit getUnitType() {
        return this.unitType;
    }

    public Longitude toBaseUnit() {
        double degrees = this.unitType.toValueInBaseUnit(this.value);
        return Longitude.of(degrees, AngleUnits.DEGREES);
    }

    public Longitude toUnit(AngleUnit targetUnit) {
        double valueInDegrees = this.unitType.toValueInBaseUnit(this.value);
        double valueInTargetUnit = targetUnit.fromValueInBaseUnit(valueInDegrees);
        return Longitude.of(valueInTargetUnit, targetUnit);
    }

    @Override
    public Longitude withValue(double value) {
        return Longitude.of(value, this.unitType);
    }

    public String toDMSFormat() {
        return DMSValueFormatter.longitudeToDmsFormat(this, -1);
    }

    public String toDMSFormat(String variableName) {
        return variableName + " = " + this.toDMSFormat();
    }

    public String toDMSFormat(int relevantDigits) {
        return DMSValueFormatter.longitudeToDmsFormat(this, relevantDigits);
    }

    public String toDMSFormat(String variableName, int relevantDigits) {
        return variableName + " = " + this.toDMSFormat(relevantDigits);
    }

    public Longitude toRadians() {
        return this.toUnit(AngleUnits.RADIANS);
    }

    public Longitude toDegrees() {
        return this.toUnit(AngleUnits.DEGREES);
    }

    public double getInRadians() {
        return this.getInUnit(AngleUnits.RADIANS);
    }

    public double getInDegrees() {
        return this.getInUnit(AngleUnits.DEGREES);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Longitude inputQuantity = (Longitude)o;
        return Double.compare(inputQuantity.toBaseUnit().getValue(), this.baseValue) == 0 && Objects.equals(this.unitType.getBaseUnit(), inputQuantity.getUnitType().getBaseUnit());
    }

    public int hashCode() {
        return Objects.hash(this.baseValue, this.unitType.getBaseUnit());
    }

    public String toString() {
        String separator = this.getUnitType().getSymbol().contains("\u00b0") ? "" : " ";
        return "Longitude{" + this.value + separator + this.unitType.getSymbol() + "}";
    }
}

