/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.geographic;

import com.synerset.unitility.unitsystem.CalculableQuantity;
import com.synerset.unitility.unitsystem.common.Angle;
import com.synerset.unitility.unitsystem.common.Distance;
import com.synerset.unitility.unitsystem.common.DistanceUnit;
import com.synerset.unitility.unitsystem.common.DistanceUnits;
import com.synerset.unitility.unitsystem.geographic.GeoCoordinate;
import com.synerset.unitility.unitsystem.geographic.HaversineEquations;
import java.util.Objects;

public class GeoDistance
implements CalculableQuantity<DistanceUnit, GeoDistance> {
    private final DistanceUnit unitType;
    private final GeoCoordinate startCoordinate;
    private final GeoCoordinate targetCoordinate;
    private final Angle trueBearing;
    private final Distance distance;

    public GeoDistance(GeoCoordinate startCoordinate, GeoCoordinate targetCoordinate, DistanceUnit unitType) {
        this.unitType = unitType;
        this.startCoordinate = startCoordinate;
        this.targetCoordinate = targetCoordinate;
        this.trueBearing = HaversineEquations.calcBearing(startCoordinate, targetCoordinate);
        this.distance = HaversineEquations.calcSphericalDistance(startCoordinate, targetCoordinate).toUnit(unitType);
    }

    public GeoDistance(GeoCoordinate startCoordinate, Angle trueBearing, Distance distance) {
        this.distance = distance;
        this.unitType = distance.getUnitType();
        this.startCoordinate = startCoordinate;
        this.trueBearing = trueBearing;
        this.targetCoordinate = HaversineEquations.calcTargetCoordinate(startCoordinate, this.trueBearing, this.distance);
    }

    public static GeoDistance of(GeoCoordinate startCoordinate, GeoCoordinate targetCoordinate, DistanceUnit unitType) {
        return new GeoDistance(startCoordinate, targetCoordinate, unitType);
    }

    public static GeoDistance of(GeoCoordinate startCoordinate, Angle trueBearing, Distance distance) {
        return new GeoDistance(startCoordinate, trueBearing, distance);
    }

    public static GeoDistance ofMeters(GeoCoordinate startCoordinate, GeoCoordinate targetCoordinate) {
        return new GeoDistance(startCoordinate, targetCoordinate, DistanceUnits.METER);
    }

    public static GeoDistance ofKilometers(GeoCoordinate startCoordinate, GeoCoordinate targetCoordinate) {
        return new GeoDistance(startCoordinate, targetCoordinate, DistanceUnits.KILOMETER);
    }

    public static GeoDistance ofMiles(GeoCoordinate startCoordinate, GeoCoordinate targetCoordinate) {
        return new GeoDistance(startCoordinate, targetCoordinate, DistanceUnits.MILE);
    }

    public static GeoDistance ofNauticalMiles(GeoCoordinate startCoordinate, GeoCoordinate targetCoordinate) {
        return new GeoDistance(startCoordinate, targetCoordinate, DistanceUnits.NAUTICAL_MILE);
    }

    public GeoDistance with(Angle trueBearing, Distance byDistance) {
        if (byDistance.isEqualZero()) {
            return this;
        }
        return GeoDistance.of(this.startCoordinate, trueBearing, byDistance);
    }

    public GeoDistance with(Distance byDistance) {
        if (byDistance.isEqualZero()) {
            return this;
        }
        return GeoDistance.of(this.startCoordinate, this.trueBearing, byDistance);
    }

    public GeoDistance with(GeoCoordinate targetCoordinate) {
        if (this.targetCoordinate.equals(targetCoordinate)) {
            return this;
        }
        return GeoDistance.of(this.startCoordinate, targetCoordinate, this.unitType);
    }

    @Override
    public GeoDistance withValue(double distanceValue) {
        return this.with(Distance.of(distanceValue, this.unitType));
    }

    public GeoDistance translate(Angle trueBearing, Distance byDistance) {
        if (byDistance.isEqualZero()) {
            return this;
        }
        return GeoDistance.of(this.targetCoordinate, trueBearing, byDistance);
    }

    public GeoDistance translate(Distance byDistance) {
        if (byDistance.isEqualZero()) {
            return this;
        }
        return this.translate(this.trueBearing, byDistance);
    }

    public GeoDistance translate(GeoCoordinate targetCoordinate) {
        if (this.targetCoordinate.equals(targetCoordinate)) {
            return this;
        }
        return GeoDistance.of(this.targetCoordinate, targetCoordinate, this.unitType);
    }

    public Angle getTrueBearing() {
        return this.trueBearing;
    }

    public GeoCoordinate getStartCoordinate() {
        return this.startCoordinate;
    }

    public GeoCoordinate getTargetCoordinate() {
        return this.targetCoordinate;
    }

    public Distance getDistance() {
        return this.distance;
    }

    @Override
    public double getValue() {
        return this.distance.getValue();
    }

    public GeoDistance toMeter() {
        return this.toUnit(DistanceUnits.METER);
    }

    public GeoDistance toKilometer() {
        return this.toUnit(DistanceUnits.KILOMETER);
    }

    public GeoDistance toMile() {
        return this.toUnit(DistanceUnits.MILE);
    }

    public GeoDistance toNauticalMile() {
        return this.toUnit(DistanceUnits.NAUTICAL_MILE);
    }

    public double getInMeters() {
        return this.getInUnit(DistanceUnits.METER);
    }

    public double getInKilometers() {
        return this.getInUnit(DistanceUnits.KILOMETER);
    }

    public double getInMiles() {
        return this.getInUnit(DistanceUnits.MILE);
    }

    public double getInNauticalMiles() {
        return this.getInUnit(DistanceUnits.NAUTICAL_MILE);
    }

    @Override
    public double getBaseValue() {
        return this.distance.getBaseValue();
    }

    @Override
    public DistanceUnit getUnitType() {
        return this.unitType;
    }

    public GeoDistance toBaseUnit() {
        return GeoDistance.of(this.startCoordinate, this.targetCoordinate, this.unitType.getBaseUnit());
    }

    public GeoDistance toUnit(DistanceUnit targetUnit) {
        return GeoDistance.of(this.startCoordinate, this.targetCoordinate, targetUnit);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoDistance that = (GeoDistance)o;
        return Objects.equals(this.unitType.getBaseUnit(), that.unitType.getBaseUnit()) && this.startCoordinate.equals(that.startCoordinate) && this.targetCoordinate.equals(that.targetCoordinate);
    }

    public int hashCode() {
        return Objects.hash(this.unitType.getBaseUnit(), this.startCoordinate.toBaseUnit(), this.targetCoordinate.toBaseUnit());
    }

    public String toString() {
        return "GeoDistance{unitType=" + this.unitType + ", startCoordinate=" + this.startCoordinate + ", targetCoordinate=" + this.targetCoordinate + ", distance=" + this.distance + "}";
    }
}

