/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.flow;

import com.synerset.unitility.unitsystem.exceptions.UnitSystemParseException;
import com.synerset.unitility.unitsystem.flow.VolumetricFlowUnit;
import com.synerset.unitility.unitsystem.util.StringTransformer;
import java.util.function.DoubleUnaryOperator;

public enum VolumetricFlowUnits implements VolumetricFlowUnit
{
    CUBIC_METERS_PER_SECOND("m\u00b3/s", val -> val, val -> val),
    CUBIC_METERS_PER_MINUTE("m\u00b3/min", val -> val / 60.0, val -> val * 60.0),
    CUBIC_METERS_PER_HOUR("m\u00b3/h", val -> val / 3600.0, val -> val * 3600.0),
    CUBIC_FEET_PER_MINUTE("ft\u00b3/min", val -> val / 2118.8800032893155, val -> val * 2118.8800032893155),
    LITRE_PER_SECOND("l/s", val -> val / 1000.0, val -> val * 1000.0),
    LITRE_PER_MINUTE("l/min", val -> val / 60000.0, val -> val * 60000.0),
    LITRE_PER_HOUR("l/h", val -> val / 3600000.0, val -> val * 3600000.0),
    GALLONS_PER_SECOND("gal/s", val -> val / 0.2641720523581484, val -> val * 0.2641720523581484),
    GALLONS_PER_MINUTE("gal/min", val -> val / 15.850610141490908, val -> val * 15.850610141490908),
    GALLONS_PER_HOUR("gal/h", val -> val / 951.0366084894545, val -> val * 951.0366084894545);

    private final String symbol;
    private final DoubleUnaryOperator toBaseConverter;
    private final DoubleUnaryOperator fromBaseToUnitConverter;

    private VolumetricFlowUnits(String symbol, DoubleUnaryOperator toBaseConverter, DoubleUnaryOperator fromBaseToUnitConverter) {
        this.symbol = symbol;
        this.toBaseConverter = toBaseConverter;
        this.fromBaseToUnitConverter = fromBaseToUnitConverter;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public VolumetricFlowUnit getBaseUnit() {
        return CUBIC_METERS_PER_SECOND;
    }

    @Override
    public double toValueInBaseUnit(double valueInThisUnit) {
        return this.toBaseConverter.applyAsDouble(valueInThisUnit);
    }

    @Override
    public double fromValueInBaseUnit(double valueInBaseUnit) {
        return this.fromBaseToUnitConverter.applyAsDouble(valueInBaseUnit);
    }

    public static VolumetricFlowUnit fromSymbol(String rawSymbol) {
        if (rawSymbol == null || rawSymbol.isBlank()) {
            return VolumetricFlowUnits.getDefaultUnit();
        }
        String requestedSymbol = VolumetricFlowUnits.unifySymbol(rawSymbol);
        for (VolumetricFlowUnits unit : VolumetricFlowUnits.values()) {
            String currentSymbol = VolumetricFlowUnits.unifySymbol(unit.getSymbol());
            if (!currentSymbol.equalsIgnoreCase(requestedSymbol)) continue;
            return unit;
        }
        throw new UnitSystemParseException("Unsupported unit symbol: {" + rawSymbol + "}. Target class: " + VolumetricFlowUnits.class.getSimpleName());
    }

    private static String unifySymbol(String inputString) {
        return StringTransformer.of(inputString).trimLowerAndClean().unifyMultiAndDiv().unifyAerialAndVol().toString();
    }

    public static VolumetricFlowUnit getDefaultUnit() {
        return CUBIC_METERS_PER_HOUR;
    }
}

