/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.flow;

import com.synerset.unitility.unitsystem.exceptions.UnitSystemParseException;
import com.synerset.unitility.unitsystem.flow.MassFlowUnit;
import com.synerset.unitility.unitsystem.util.StringTransformer;
import java.util.function.DoubleUnaryOperator;

public enum MassFlowUnits implements MassFlowUnit
{
    KILOGRAM_PER_SECOND("kg/s", val -> val, val -> val),
    KILOGRAM_PER_HOUR("kg/h", val -> val / 3600.0, val -> val * 3600.0),
    TONNE_PER_HOUR("t/h", val -> val * 0.2777777777777778, val -> val / 0.2777777777777778),
    POUND_PER_SECOND("lb/s", val -> val * 0.45359237, val -> val / 0.45359237);

    private final String symbol;
    private final DoubleUnaryOperator toBaseConverter;
    private final DoubleUnaryOperator fromBaseToUnitConverter;

    private MassFlowUnits(String symbol, DoubleUnaryOperator toBaseConverter, DoubleUnaryOperator fromBaseToUnitConverter) {
        this.symbol = symbol;
        this.toBaseConverter = toBaseConverter;
        this.fromBaseToUnitConverter = fromBaseToUnitConverter;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public MassFlowUnit getBaseUnit() {
        return KILOGRAM_PER_SECOND;
    }

    @Override
    public double toValueInBaseUnit(double valueInThisUnit) {
        return this.toBaseConverter.applyAsDouble(valueInThisUnit);
    }

    @Override
    public double fromValueInBaseUnit(double valueInBaseUnit) {
        return this.fromBaseToUnitConverter.applyAsDouble(valueInBaseUnit);
    }

    public static MassFlowUnit fromSymbol(String rawSymbol) {
        if (rawSymbol == null || rawSymbol.isBlank()) {
            return MassFlowUnits.getDefaultUnit();
        }
        String requestedSymbol = MassFlowUnits.unifySymbol(rawSymbol);
        for (MassFlowUnits unit : MassFlowUnits.values()) {
            String currentSymbol = MassFlowUnits.unifySymbol(unit.getSymbol());
            if (!currentSymbol.equalsIgnoreCase(requestedSymbol)) continue;
            return unit;
        }
        throw new UnitSystemParseException("Unsupported unit symbol: {" + rawSymbol + "}. Target class: " + MassFlowUnits.class.getSimpleName());
    }

    private static String unifySymbol(String inputString) {
        return StringTransformer.of(inputString).trimLowerAndClean().unifyMultiAndDiv().toString();
    }

    public static MassFlowUnit getDefaultUnit() {
        return KILOGRAM_PER_SECOND;
    }
}

