/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.common;

import com.synerset.unitility.unitsystem.CalculableQuantity;
import com.synerset.unitility.unitsystem.common.VelocityUnit;
import com.synerset.unitility.unitsystem.common.VelocityUnits;
import java.util.Objects;

public class Velocity
implements CalculableQuantity<VelocityUnit, Velocity> {
    private final double value;
    private final double baseValue;
    private final VelocityUnit unitType;

    public Velocity(double value, VelocityUnit unitType) {
        this.value = value;
        if (unitType == null) {
            unitType = VelocityUnits.getDefaultUnit();
        }
        this.unitType = unitType;
        this.baseValue = unitType.toValueInBaseUnit(value);
    }

    public static Velocity of(double value, VelocityUnit unit) {
        return new Velocity(value, unit);
    }

    public static Velocity of(double value, String unitSymbol) {
        VelocityUnit resolvedUnit = VelocityUnits.fromSymbol(unitSymbol);
        return new Velocity(value, resolvedUnit);
    }

    public static Velocity ofMetersPerSecond(double value) {
        return new Velocity(value, VelocityUnits.METER_PER_SECOND);
    }

    public static Velocity ofCentimetersPerSecond(double value) {
        return new Velocity(value, VelocityUnits.CENTIMETER_PER_SECOND);
    }

    public static Velocity ofKilometersPerHour(double value) {
        return new Velocity(value, VelocityUnits.KILOMETER_PER_HOUR);
    }

    public static Velocity ofInchesPerSecond(double value) {
        return new Velocity(value, VelocityUnits.INCH_PER_SECOND);
    }

    public static Velocity ofFeetPerSecond(double value) {
        return new Velocity(value, VelocityUnits.FEET_PER_SECOND);
    }

    public static Velocity ofMilesPerHour(double value) {
        return new Velocity(value, VelocityUnits.MILES_PER_HOUR);
    }

    public static Velocity ofKnots(double value) {
        return new Velocity(value, VelocityUnits.KNOT);
    }

    public static Velocity ofMach(double value) {
        return new Velocity(value, VelocityUnits.MACH);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public VelocityUnit getUnitType() {
        return this.unitType;
    }

    public Velocity toBaseUnit() {
        double valueInMetersPerSecond = this.unitType.toValueInBaseUnit(this.value);
        return Velocity.of(valueInMetersPerSecond, VelocityUnits.METER_PER_SECOND);
    }

    public Velocity toUnit(VelocityUnit targetUnit) {
        double valueInMetersPerSecond = this.unitType.toValueInBaseUnit(this.value);
        double valueInTargetUnit = targetUnit.fromValueInBaseUnit(valueInMetersPerSecond);
        return Velocity.of(valueInTargetUnit, targetUnit);
    }

    @Override
    public Velocity withValue(double value) {
        return Velocity.of(value, this.unitType);
    }

    public Velocity toMetersPerSecond() {
        return this.toUnit(VelocityUnits.METER_PER_SECOND);
    }

    public Velocity toCentimetersPerSecond() {
        return this.toUnit(VelocityUnits.CENTIMETER_PER_SECOND);
    }

    public Velocity toKilometersPerHour() {
        return this.toUnit(VelocityUnits.KILOMETER_PER_HOUR);
    }

    public Velocity toInchesPerSecond() {
        return this.toUnit(VelocityUnits.INCH_PER_SECOND);
    }

    public Velocity toFeetPerSecond() {
        return this.toUnit(VelocityUnits.FEET_PER_SECOND);
    }

    public Velocity toMilesPerHour() {
        return this.toUnit(VelocityUnits.MILES_PER_HOUR);
    }

    public Velocity toKnots() {
        return this.toUnit(VelocityUnits.KNOT);
    }

    public Velocity toMach() {
        return this.toUnit(VelocityUnits.MACH);
    }

    public double getInMetersPerSecond() {
        return this.getInUnit(VelocityUnits.METER_PER_SECOND);
    }

    public double getInCentimetersPerSeconds() {
        return this.getInUnit(VelocityUnits.CENTIMETER_PER_SECOND);
    }

    public double getInKilometersPerHours() {
        return this.getInUnit(VelocityUnits.KILOMETER_PER_HOUR);
    }

    public double getInInchesPerSeconds() {
        return this.getInUnit(VelocityUnits.INCH_PER_SECOND);
    }

    public double getInFeetPerSeconds() {
        return this.getInUnit(VelocityUnits.FEET_PER_SECOND);
    }

    public double getInMilesPerHours() {
        return this.getInUnit(VelocityUnits.MILES_PER_HOUR);
    }

    public double getInKnots() {
        return this.getInUnit(VelocityUnits.KNOT);
    }

    public double getInMach() {
        return this.getInUnit(VelocityUnits.MACH);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Velocity inputQuantity = (Velocity)o;
        return Double.compare(inputQuantity.toBaseUnit().getValue(), this.baseValue) == 0 && Objects.equals(this.unitType.getBaseUnit(), inputQuantity.getUnitType().getBaseUnit());
    }

    public int hashCode() {
        return Objects.hash(this.baseValue, this.unitType.getBaseUnit());
    }

    public String toString() {
        return "Velocity{" + this.value + " " + this.unitType.getSymbol() + "}";
    }
}

