/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.common;

import com.synerset.unitility.unitsystem.common.MassUnit;
import com.synerset.unitility.unitsystem.exceptions.UnitSystemParseException;
import com.synerset.unitility.unitsystem.util.StringTransformer;
import java.util.function.DoubleUnaryOperator;

public enum MassUnits implements MassUnit
{
    KILOGRAM("kg", val -> val, val -> val),
    GRAM("g", val -> val * 0.001, val -> val / 0.001),
    MILLIGRAM("mg", val -> val * 1.0E-6, val -> val / 1.0E-6),
    TONNE_SI("t", val -> val * 1000.0, val -> val / 1000.0),
    OUNCE("oz", val -> val * 0.028349523125, val -> val / 0.028349523125),
    POUND("lb", val -> val * 0.45359237, val -> val / 0.45359237);

    private final String symbol;
    private final DoubleUnaryOperator toBaseConverter;
    private final DoubleUnaryOperator fromBaseToUnitConverter;

    private MassUnits(String symbol, DoubleUnaryOperator toBaseConverter, DoubleUnaryOperator fromBaseToUnitConverter) {
        this.symbol = symbol;
        this.toBaseConverter = toBaseConverter;
        this.fromBaseToUnitConverter = fromBaseToUnitConverter;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public MassUnit getBaseUnit() {
        return KILOGRAM;
    }

    @Override
    public double toValueInBaseUnit(double valueInThisUnit) {
        return this.toBaseConverter.applyAsDouble(valueInThisUnit);
    }

    @Override
    public double fromValueInBaseUnit(double valueInBaseUnit) {
        return this.fromBaseToUnitConverter.applyAsDouble(valueInBaseUnit);
    }

    public static MassUnit fromSymbol(String rawSymbol) {
        if (rawSymbol == null || rawSymbol.isBlank()) {
            return MassUnits.getDefaultUnit();
        }
        String requestedSymbol = MassUnits.unifySymbol(rawSymbol);
        for (MassUnits unit : MassUnits.values()) {
            String currentSymbol = MassUnits.unifySymbol(unit.getSymbol());
            if (!currentSymbol.equalsIgnoreCase(requestedSymbol)) continue;
            return unit;
        }
        throw new UnitSystemParseException("Unsupported unit symbol: {" + rawSymbol + "}. Target class: " + MassUnits.class.getSimpleName());
    }

    private static String unifySymbol(String inputString) {
        return StringTransformer.of(inputString).trimLowerAndClean().toString();
    }

    public static MassUnit getDefaultUnit() {
        return KILOGRAM;
    }
}

