/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.common;

import com.synerset.unitility.unitsystem.CalculableQuantity;
import com.synerset.unitility.unitsystem.common.MassUnit;
import com.synerset.unitility.unitsystem.common.MassUnits;
import java.util.Objects;

public class Mass
implements CalculableQuantity<MassUnit, Mass> {
    public static final Mass PHYSICAL_MIN_LIMIT = Mass.ofKilograms(0.0);
    private final double value;
    private final double baseValue;
    private final MassUnit unitType;

    public Mass(double value, MassUnit unitType) {
        this.value = value;
        if (unitType == null) {
            unitType = MassUnits.getDefaultUnit();
        }
        this.unitType = unitType;
        this.baseValue = unitType.toValueInBaseUnit(value);
    }

    public static Mass of(double value, MassUnit unit) {
        return new Mass(value, unit);
    }

    public static Mass of(double value, String unitSymbol) {
        MassUnit resolvedUnit = MassUnits.fromSymbol(unitSymbol);
        return new Mass(value, resolvedUnit);
    }

    public static Mass ofKilograms(double value) {
        return new Mass(value, MassUnits.KILOGRAM);
    }

    public static Mass ofGrams(double value) {
        return new Mass(value, MassUnits.GRAM);
    }

    public static Mass ofMilligrams(double value) {
        return new Mass(value, MassUnits.MILLIGRAM);
    }

    public static Mass ofTonneSI(double value) {
        return new Mass(value, MassUnits.TONNE_SI);
    }

    public static Mass ofOunces(double value) {
        return new Mass(value, MassUnits.OUNCE);
    }

    public static Mass ofPounds(double value) {
        return new Mass(value, MassUnits.POUND);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public MassUnit getUnitType() {
        return this.unitType;
    }

    public Mass toBaseUnit() {
        double valueInKilogram = this.unitType.toValueInBaseUnit(this.value);
        return Mass.of(valueInKilogram, MassUnits.KILOGRAM);
    }

    public Mass toUnit(MassUnit targetUnit) {
        double valueInKilogram = this.unitType.toValueInBaseUnit(this.value);
        double valueInTargetUnit = targetUnit.fromValueInBaseUnit(valueInKilogram);
        return Mass.of(valueInTargetUnit, targetUnit);
    }

    @Override
    public Mass withValue(double value) {
        return Mass.of(value, this.unitType);
    }

    public Mass toKilogram() {
        return this.toUnit(MassUnits.KILOGRAM);
    }

    public Mass toGram() {
        return this.toUnit(MassUnits.GRAM);
    }

    public Mass toMilligram() {
        return this.toUnit(MassUnits.MILLIGRAM);
    }

    public Mass toTonneSI() {
        return this.toUnit(MassUnits.TONNE_SI);
    }

    public Mass toOunce() {
        return this.toUnit(MassUnits.OUNCE);
    }

    public Mass toPound() {
        return this.toUnit(MassUnits.POUND);
    }

    public double getInKilograms() {
        return this.getInUnit(MassUnits.KILOGRAM);
    }

    public double getIntoGrams() {
        return this.getInUnit(MassUnits.GRAM);
    }

    public double getInMilligrams() {
        return this.getInUnit(MassUnits.MILLIGRAM);
    }

    public double getIntoTonnesSI() {
        return this.getInUnit(MassUnits.TONNE_SI);
    }

    public double getIntoOunces() {
        return this.getInUnit(MassUnits.OUNCE);
    }

    public double getInPounds() {
        return this.getInUnit(MassUnits.POUND);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Mass inputQuantity = (Mass)o;
        return Double.compare(inputQuantity.toBaseUnit().getValue(), this.baseValue) == 0 && Objects.equals(this.unitType.getBaseUnit(), inputQuantity.getUnitType().getBaseUnit());
    }

    public int hashCode() {
        return Objects.hash(this.baseValue, this.unitType.getBaseUnit());
    }

    public String toString() {
        return "Mass{" + this.value + " " + this.unitType.getSymbol() + "}";
    }
}

