/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.common;

import com.synerset.unitility.unitsystem.common.AreaUnit;
import com.synerset.unitility.unitsystem.exceptions.UnitSystemParseException;
import com.synerset.unitility.unitsystem.util.StringTransformer;
import java.util.function.DoubleUnaryOperator;

public enum AreaUnits implements AreaUnit
{
    SQUARE_METER("m\u00b2", val -> val, val -> val),
    SQUARE_KILOMETER("km\u00b2", val -> val * 1000000.0, val -> val / 1000000.0),
    SQUARE_CENTIMETER("cm\u00b2", val -> val / 10000.0, val -> val * 10000.0),
    SQUARE_MILLIMETER("mm\u00b2", val -> val / 1000000.0, val -> val * 1000000.0),
    ARE("a", val -> val * 100.0, val -> val / 100.0),
    HECTARE("ha", val -> val * 10000.0, val -> val / 10000.0),
    SQUARE_INCH("in\u00b2", val -> val * 6.4516E-4, val -> val / 6.4516E-4),
    SQUARE_FOOT("ft\u00b2", val -> val * 0.09290304, val -> val / 0.09290304),
    SQUARE_YARD("yd\u00b2", val -> val * 0.83612736, val -> val / 0.83612736),
    ACRE("ac", val -> val * 4046.8564224, val -> val / 4046.8564224),
    SQUARE_MILE("mi\u00b2", val -> val * 2589988.110336, val -> val / 2589988.110336);

    private final String symbol;
    private final DoubleUnaryOperator toBaseConverter;
    private final DoubleUnaryOperator fromBaseToUnitConverter;

    private AreaUnits(String symbol, DoubleUnaryOperator toBaseConverter, DoubleUnaryOperator fromBaseToUnitConverter) {
        this.symbol = symbol;
        this.toBaseConverter = toBaseConverter;
        this.fromBaseToUnitConverter = fromBaseToUnitConverter;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public AreaUnits getBaseUnit() {
        return SQUARE_METER;
    }

    @Override
    public double toValueInBaseUnit(double valueInThisUnit) {
        return this.toBaseConverter.applyAsDouble(valueInThisUnit);
    }

    @Override
    public double fromValueInBaseUnit(double valueInBaseUnit) {
        return this.fromBaseToUnitConverter.applyAsDouble(valueInBaseUnit);
    }

    public static AreaUnit fromSymbol(String rawSymbol) {
        if (rawSymbol == null || rawSymbol.isBlank()) {
            return AreaUnits.getDefaultUnit();
        }
        String requestedSymbol = AreaUnits.unifySymbol(rawSymbol);
        for (AreaUnits unit : AreaUnits.values()) {
            String currentSymbol = AreaUnits.unifySymbol(unit.getSymbol());
            if (!currentSymbol.equalsIgnoreCase(requestedSymbol)) continue;
            return unit;
        }
        throw new UnitSystemParseException("Unsupported unit symbol: {" + rawSymbol + "}. Target class: " + AreaUnits.class.getSimpleName());
    }

    private static String unifySymbol(String inputString) {
        return StringTransformer.of(inputString).trimLowerAndClean().unifyAerialAndVol().toString();
    }

    public static AreaUnit getDefaultUnit() {
        return SQUARE_METER;
    }
}

