/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem;

import com.synerset.unitility.unitsystem.CalculableQuantity;
import com.synerset.unitility.unitsystem.common.AngleUnit;
import com.synerset.unitility.unitsystem.common.AngleUnits;
import com.synerset.unitility.unitsystem.exceptions.UnitSystemArgumentException;
import java.util.function.DoubleUnaryOperator;

public interface TrigonometricQuantity<Q extends CalculableQuantity<AngleUnit, Q>>
extends CalculableQuantity<AngleUnit, Q> {
    default public double sin() {
        return this.applyTrigonometricFunction(Math::sin);
    }

    default public double sinh() {
        return this.applyTrigonometricFunction(Math::sinh);
    }

    default public double asin() {
        double value = this.getValueInRadians();
        if (value < -1.0 || value > 1.0) {
            throw new UnitSystemArgumentException("Value out of range for arcsine. Valid range is [-1, 1].");
        }
        return this.applyTrigonometricFunction(Math::asin);
    }

    default public double cos() {
        return this.applyTrigonometricFunction(Math::cos);
    }

    default public double cosh() {
        return this.applyTrigonometricFunction(Math::cosh);
    }

    default public double acos() {
        double value = this.getValueInRadians();
        if (value < -1.0 || value > 1.0) {
            throw new UnitSystemArgumentException("Value out of range for arccosine. Valid range is [-1, 1].");
        }
        return this.applyTrigonometricFunction(Math::acos);
    }

    default public double tan() {
        double value = this.getValueInRadians();
        if (this.isMultipleOfPiOverTwo(value)) {
            throw new UnitSystemArgumentException("Tangent is undefined for odd multiples of \u03c0/2.");
        }
        return this.applyTrigonometricFunction(Math::tan);
    }

    default public double tanh() {
        return this.applyTrigonometricFunction(Math::tanh);
    }

    default public double atan() {
        return this.applyTrigonometricFunction(Math::atan);
    }

    default public double cot() {
        double value = this.getValueInRadians();
        if (this.isMultipleOfPi(value)) {
            throw new UnitSystemArgumentException("Cotangent is undefined for multiples of \u03c0.");
        }
        return 1.0 / this.tan();
    }

    default public double coth() {
        double value = this.getValueInRadians();
        if (value == 0.0) {
            throw new UnitSystemArgumentException("Hyperbolic cotangent is undefined for 0.");
        }
        return 1.0 / this.tanh();
    }

    default public double acot() {
        return 1.0 / this.atan();
    }

    private double applyTrigonometricFunction(DoubleUnaryOperator unaryOperator) {
        double unitInRadians = this.getValueInRadians();
        return unaryOperator.applyAsDouble(unitInRadians);
    }

    private double getValueInRadians() {
        return this.toUnit(AngleUnits.RADIANS).getValue();
    }

    private boolean isMultipleOfPiOverTwo(double value) {
        return Math.abs(value / 1.5707963267948966 % 1.0) < 1.0E-10;
    }

    private boolean isMultipleOfPi(double value) {
        return Math.abs(value / Math.PI % 1.0) < 1.0E-10;
    }
}

