/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem;

import com.synerset.unitility.unitsystem.Unit;
import com.synerset.unitility.unitsystem.util.ValueFormatter;
import java.util.Objects;

public interface PhysicalQuantity<U extends Unit>
extends Comparable<PhysicalQuantity<U>> {
    public PhysicalQuantity<U> withValue(double var1);

    public double getValue();

    public double getBaseValue();

    public U getUnitType();

    public PhysicalQuantity<U> toBaseUnit();

    public PhysicalQuantity<U> toUnit(U var1);

    default public String getUnitSymbol() {
        return this.getUnitType().getSymbol();
    }

    default public double getInUnit(U targetUnit) {
        return targetUnit.fromValueInBaseUnit(this.getBaseValue());
    }

    default public <Q extends PhysicalQuantity<U>> Q toUnitFrom(Q targetUnit) {
        U targetUnitUnitT = targetUnit.getUnitType();
        return (Q)this.toUnit(targetUnitUnitT);
    }

    default public boolean isGreaterThan(PhysicalQuantity<U> quantity) {
        if (Objects.isNull(quantity)) {
            return false;
        }
        double condition = this.toBaseUnit().getValue() - quantity.toBaseUnit().getValue();
        return condition > 0.0;
    }

    default public boolean isEqualOrGreaterThan(PhysicalQuantity<U> quantity) {
        if (Objects.isNull(quantity)) {
            return false;
        }
        double condition = this.toBaseUnit().getValue() - quantity.toBaseUnit().getValue();
        return condition >= 0.0;
    }

    default public boolean isLowerThan(PhysicalQuantity<U> quantity) {
        if (Objects.isNull(quantity)) {
            return false;
        }
        double condition = this.toBaseUnit().getValue() - quantity.toBaseUnit().getValue();
        return condition < 0.0;
    }

    default public boolean isEqualOrLowerThan(PhysicalQuantity<U> quantity) {
        if (Objects.isNull(quantity)) {
            return false;
        }
        double condition = this.toBaseUnit().getValue() - quantity.toBaseUnit().getValue();
        return condition <= 0.0;
    }

    default public boolean isEqualWithPrecision(PhysicalQuantity<U> quantity, double epsilon) {
        double inputValue;
        if (this == quantity) {
            return true;
        }
        if (quantity == null || this.getClass() != quantity.getClass()) {
            return false;
        }
        PhysicalQuantity<U> thisInBaseUnit = this.toBaseUnit();
        PhysicalQuantity<U> inputInBaseUnit = quantity.toBaseUnit();
        if (thisInBaseUnit.getUnitType() != inputInBaseUnit.getUnitType()) {
            return false;
        }
        double thisValue = thisInBaseUnit.getValue();
        return Math.abs(thisValue - (inputValue = inputInBaseUnit.getValue())) < epsilon;
    }

    default public boolean isPositive() {
        return this.getValue() > 0.0;
    }

    default public boolean isPositiveOrZero() {
        return this.getValue() >= 0.0;
    }

    default public boolean isNegative() {
        return this.getValue() < 0.0;
    }

    default public boolean isNegativeOrZero() {
        return this.getValue() <= 0.0;
    }

    default public boolean isEqualZero() {
        return this.getValue() == 0.0;
    }

    default public boolean isCloseToZero() {
        return Math.abs(this.getValue()) < 1.0E-12;
    }

    default public boolean isCloseToZero(double epsilon) {
        return Math.abs(this.getValue()) < epsilon;
    }

    default public String toEngineeringFormat() {
        if (this.getUnitSymbol().isBlank()) {
            return String.valueOf(this.getValue());
        }
        return String.format("%s [%s]", this.getValue(), this.getUnitSymbol());
    }

    default public String toEngineeringFormat(String variableName) {
        if (this.getUnitSymbol().isBlank()) {
            return String.valueOf(this.getValue());
        }
        return variableName + " = " + this.toEngineeringFormat();
    }

    default public String toEngineeringFormat(int relevantDigits) {
        if (this.getUnitSymbol().isBlank()) {
            return ValueFormatter.toStringWithRelevantDigits(this.getValue(), relevantDigits);
        }
        return String.format("%s [%s]", ValueFormatter.toStringWithRelevantDigits(this.getValue(), relevantDigits), this.getUnitSymbol());
    }

    default public String toEngineeringFormat(String variableName, int relevantDigits) {
        return variableName + " = " + this.toEngineeringFormat(relevantDigits);
    }

    @Override
    default public int compareTo(PhysicalQuantity<U> other) {
        if (other == null) {
            throw new NullPointerException("Cannot compare to null");
        }
        if (this == other) {
            return 0;
        }
        PhysicalQuantity<U> thisInOtherUnit = this.toUnit(other.getUnitType());
        double thisValue = thisInOtherUnit.getValue();
        double otherValue = other.getValue();
        return Double.compare(thisValue, otherValue);
    }
}

